/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tika.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.ZeroByteFileException;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TikaUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger(TikaUtils.class);
    private static Tika tika;

    private TikaUtils() {
    }

    public static Tika getTika() {
        return tika;
    }

    private static InputStream safeInputStream(InputStream stream) {
        if (stream instanceof AutoCloseInputStream) {
            return new BufferedInputStream(stream);
        }
        return stream;
    }

    public static String detect(File file) throws IOException {
        return tika.detect(file);
    }

    public static String detect(Path path) throws IOException {
        return tika.detect(path);
    }

    public static String detect(InputStream stream, String name) throws IOException {
        return tika.detect(TikaUtils.safeInputStream(stream), name);
    }

    public static String detect(InputStream stream) throws IOException {
        return tika.detect(stream);
    }

    public static String detect(String name) {
        return tika.detect(name);
    }

    public static String parseToString(InputStream stream, Metadata metadata) throws IOException, TikaException {
        try {
            return tika.parseToString(TikaUtils.safeInputStream(stream), metadata);
        }
        catch (ZeroByteFileException e) {
            return "";
        }
    }

    public static String parseToString(InputStream stream) throws IOException, TikaException {
        try {
            return tika.parseToString(TikaUtils.safeInputStream(stream));
        }
        catch (ZeroByteFileException e) {
            return "";
        }
    }

    public static String parseToString(Path path) throws IOException, TikaException {
        try {
            return tika.parseToString(path);
        }
        catch (ZeroByteFileException e) {
            return "";
        }
    }

    public static String parseToString(File file) throws IOException, TikaException {
        try {
            return tika.parseToString(file);
        }
        catch (ZeroByteFileException e) {
            return "";
        }
    }

    public static String parseToString(URL url) throws IOException, TikaException {
        try {
            return tika.parseToString(url);
        }
        catch (ZeroByteFileException e) {
            return "";
        }
    }

    static {
        try {
            tika = new Tika(new TikaConfig(TikaUtils.class.getResource("/tika-config.xml")));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load tika configuration (default configuration will be used): {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            tika = new Tika();
        }
    }
}

