/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tag.internal.selector;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.tag.internal.TagException;
import org.xwiki.tag.internal.TagsSelector;

public abstract class AbstractTagsSelector
implements TagsSelector {
    @Inject
    protected Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="hidden/document")
    protected QueryFilter hiddenDocumentQueryFilter;
    @Inject
    @Named(value="unique")
    protected QueryFilter uniqueDocumentQueryFilter;
    @Inject
    protected ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    @Named(value="current")
    protected DocumentReferenceResolver<String> stringDocumentReferenceResolver;

    @Override
    public List<String> getDocumentsWithTag(String tag, boolean includeHiddenDocuments, boolean caseSensitive) throws TagException {
        Object hql = ", BaseObject as obj, DBStringListProperty as prop join prop.list item where obj.className=:className and obj.name=doc.fullName and obj.id=prop.id.id and prop.id.name='tags'";
        hql = caseSensitive ? (String)hql + " and item = :item" : (String)hql + " and lower(item)=lower(:item)";
        try {
            ArrayList<String> documents;
            Query query = ((XWikiContext)this.contextProvider.get()).getWiki().getStore().getQueryManager().createQuery((String)hql, "hql");
            query.bindValue("className", (Object)"XWiki.TagClass");
            query.bindValue("item", (Object)tag);
            query.addFilter(this.uniqueDocumentQueryFilter);
            if (!includeHiddenDocuments) {
                query.addFilter(this.hiddenDocumentQueryFilter);
            }
            ArrayList<String> rows = query.execute();
            if (this.isUnsafe()) {
                documents = rows;
            } else {
                documents = new ArrayList<String>();
                for (String documentReferenceRepresentation : rows) {
                    if (!this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)this.stringDocumentReferenceResolver.resolve((Object)documentReferenceRepresentation, new Object[0]))) continue;
                    documents.add(documentReferenceRepresentation);
                }
            }
            return documents;
        }
        catch (QueryException e) {
            throw new TagException(String.format("Failed to search for document with tag [%s]", tag), e);
        }
    }

    boolean isUnsafe() {
        return false;
    }
}

