/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.tag;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.web.Utils;
import java.util.List;
import java.util.Map;
import org.xwiki.stability.Unstable;
import org.xwiki.tag.internal.TagException;
import org.xwiki.tag.internal.TagsSelector;

public final class TagQueryUtils {
    public static final String HIDDEN_QUERYFILTER_HINT = "hidden/document";
    private static TagsSelector tagsSelector;

    private TagQueryUtils() {
    }

    public static List<String> getAllTags(XWikiContext context) throws XWikiException {
        try {
            return TagQueryUtils.getTagsSelector().getAllTags();
        }
        catch (TagException e) {
            throw new XWikiException(3, 0, "Failed to get all tags", (Throwable)e);
        }
    }

    public static Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, List<?> parameterValues, XWikiContext context) throws XWikiException {
        try {
            return TagQueryUtils.getTagsSelector().getTagCountForQuery(fromHql, whereHql, parameterValues);
        }
        catch (TagException e) {
            throw new XWikiException(3, 0, String.format("Failed to count tags for where fromHql = [%s] and whereHql = [%s] and parameterValues = [%s].", fromHql, whereHql, parameterValues), (Throwable)e);
        }
    }

    public static Map<String, Integer> getTagCountForQuery(String fromHql, String whereHql, Map<String, ?> parameters, XWikiContext context) throws XWikiException {
        try {
            return TagQueryUtils.getTagsSelector().getTagCountForQuery(fromHql, whereHql, parameters);
        }
        catch (TagException e) {
            throw new XWikiException(3, 0, String.format("Failed to count tags for where fromHql = [%s] and whereHql = [%s] and parameters = [%s].", fromHql, whereHql, parameters), (Throwable)e);
        }
    }

    public static List<String> getDocumentsWithTag(String tag, XWikiContext context) throws XWikiException {
        return TagQueryUtils.getDocumentsWithTag(tag, false, context);
    }

    public static List<String> getDocumentsWithTag(String tag, boolean includeHiddenDocuments, XWikiContext context) throws XWikiException {
        return TagQueryUtils.getDocumentsWithTag(tag, includeHiddenDocuments, false);
    }

    @Unstable
    public static List<String> getDocumentsWithTag(String tag, boolean includeHiddenDocuments, boolean caseSensitive) throws XWikiException {
        try {
            return TagQueryUtils.getTagsSelector().getDocumentsWithTag(tag, includeHiddenDocuments, caseSensitive);
        }
        catch (TagException e) {
            throw new XWikiException(3, 0, String.format("Failed to get all documents with tag [%s]", tag), (Throwable)e);
        }
    }

    private static TagsSelector getTagsSelector() {
        if (tagsSelector == null) {
            tagsSelector = (TagsSelector)Utils.getComponent(TagsSelector.class);
        }
        return tagsSelector;
    }
}

