/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.tag;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.tag.TagOperationResult;
import com.xpn.xwiki.plugin.tag.TagPlugin;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagPluginApi
extends PluginApi<TagPlugin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TagPluginApi.class);
    private static final String TAG_ACCESS_RIGHT = "edit";

    public TagPluginApi(TagPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    public List<String> getAllTags() throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getAllTags(this.context);
    }

    public Map<String, Integer> getTagCount() throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getTagCount(this.context);
    }

    public Map<String, Integer> getTagCount(String space) throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getTagCount(space, this.context);
    }

    public Map<String, Integer> getTagCountForSpaces(String spaces) throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getTagCountForSpaces(spaces, this.context);
    }

    public Map<String, Integer> getTagCountForQuery(String from, String where) throws XWikiException {
        return this.getTagCountForQuery(from, where, (Map)null);
    }

    public Map<String, Integer> getTagCountForQuery(String from, String where, List<?> parameterValues) throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getTagCountForQuery(from, where, parameterValues, this.context);
    }

    public Map<String, Integer> getTagCountForQuery(String from, String where, Map<String, ?> parameters) throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getTagCountForQuery(from, where, parameters, this.context);
    }

    public List<String> getDocumentsWithTag(String tag) throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getDocumentsWithTag(tag, this.context);
    }

    public List<String> getTagsFromDocument(String documentName) throws XWikiException {
        return ((TagPlugin)this.getProtectedPlugin()).getTagsFromDocument(documentName, this.context);
    }

    public TagOperationResult addTagToDocument(String tag, String documentName) {
        TagOperationResult result;
        try {
            XWikiDocument document = this.context.getWiki().getDocument(documentName, this.context);
            if (this.context.getWiki().checkAccess(TAG_ACCESS_RIGHT, document, this.context)) {
                document = document.clone();
                result = ((TagPlugin)this.getProtectedPlugin()).addTagToDocument(tag, document, this.context);
            } else {
                result = TagOperationResult.NOT_ALLOWED;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to add tag to document: [{}]", (Object)ex.getMessage());
            result = TagOperationResult.FAILED;
        }
        return result;
    }

    public TagOperationResult addTagsToDocument(String tags, String documentName) {
        TagOperationResult result;
        try {
            XWikiDocument document = this.context.getWiki().getDocument(documentName, this.context);
            if (this.context.getWiki().checkAccess(TAG_ACCESS_RIGHT, document, this.context)) {
                document = document.clone();
                result = ((TagPlugin)this.getProtectedPlugin()).addTagsToDocument(tags, document, this.context);
            } else {
                result = TagOperationResult.NOT_ALLOWED;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to add tags to document: [{}]", (Object)ex.getMessage());
            result = TagOperationResult.FAILED;
        }
        return result;
    }

    public TagOperationResult removeTagFromDocument(String tag, String documentName) {
        TagOperationResult result;
        try {
            XWikiDocument document = this.context.getWiki().getDocument(documentName, this.context);
            result = this.context.getWiki().checkAccess(TAG_ACCESS_RIGHT, document, this.context) ? ((TagPlugin)this.getProtectedPlugin()).removeTagFromDocument(tag, documentName, this.context) : TagOperationResult.NOT_ALLOWED;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to remove tag from document: [{}]", (Object)ex.getMessage());
            result = TagOperationResult.FAILED;
        }
        return result;
    }

    public TagOperationResult renameTag(String tag, String newTag) {
        TagOperationResult result;
        try {
            result = this.hasAdminRights() ? ((TagPlugin)this.getProtectedPlugin()).renameTag(tag, newTag, this.context) : TagOperationResult.NOT_ALLOWED;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to rename tag: [{}]", (Object)ex.getMessage());
            result = TagOperationResult.FAILED;
        }
        return result;
    }

    public TagOperationResult deleteTag(String tag) {
        TagOperationResult result;
        try {
            result = this.hasAdminRights() ? ((TagPlugin)this.getProtectedPlugin()).deleteTag(tag, this.context) : TagOperationResult.NOT_ALLOWED;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to delete tag: [{}]", (Object)ex.getMessage());
            result = TagOperationResult.FAILED;
        }
        return result;
    }
}

