/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.xwiki.store.ProvidingTransactionRunnable;
import org.xwiki.store.TransactionException;

public class TransactionRunnable<T> {
    private final List<TransactionRunnable> allRunnables = new ArrayList<TransactionRunnable>();
    private TransactionRunnable<T> parent;
    private boolean hasPreRun;

    public <U extends T> TransactionRunnable<U> runIn(TransactionRunnable<U> parentRunnable) {
        if (this.parent != null) {
            throw new IllegalStateException("This TransactionRunnable is already scheduled to run inside " + this.parent.toString() + " and cannot be run in " + parentRunnable.toString() + " too.");
        }
        if (parentRunnable.hasPreRun) {
            throw new IllegalStateException("This TransactionRunnable cannot be runIn() " + String.valueOf(parentRunnable) + " because it has already started 'the ship has set sail'");
        }
        parentRunnable.assertNoLoop(this);
        this.parent = parentRunnable;
        parentRunnable.allRunnables.add(this);
        return this;
    }

    protected T getContext() {
        if (this.parent != null) {
            if (this.parent instanceof ProvidingTransactionRunnable) {
                return (T)((ProvidingTransactionRunnable)this.parent).getProvidedContext();
            }
            return this.parent.getContext();
        }
        return null;
    }

    protected void onPreRun() throws Exception {
    }

    protected void onRun() throws Exception {
    }

    protected void onCommit() throws Exception {
    }

    protected void onRollback() throws Exception {
    }

    protected void onComplete() throws Exception {
    }

    private void assertNoLoop(TransactionRunnable runnable) {
        if (this == runnable) {
            throw new IllegalArgumentException("A TransactionRunnable cannot be run inside of itself as it would create a loop which would never resolve.");
        }
        if (this.parent != null) {
            this.parent.assertNoLoop(runnable);
        }
    }

    protected final void preRun() throws TransactionException {
        ListIterator<TransactionRunnable> runPathIterator = this.getRunPath().listIterator();
        try {
            while (runPathIterator.hasNext()) {
                TransactionRunnable tr = runPathIterator.next();
                tr.hasPreRun = true;
                tr.onPreRun();
            }
        }
        catch (Throwable t) {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            errors.add(t);
            try {
                TransactionRunnable.completeAll(runPathIterator);
            }
            catch (TransactionException e) {
                errors.add(e);
            }
            throw new TransactionException("Failure in onPreRun()", errors, false);
        }
    }

    private List<TransactionRunnable> getRunPath() {
        ArrayList<TransactionRunnable> runPath = new ArrayList<TransactionRunnable>();
        this.addAllToRunPath(runPath);
        return runPath;
    }

    private void addAllToRunPath(List<TransactionRunnable> runPath) {
        runPath.add(this);
        for (TransactionRunnable run : this.allRunnables) {
            run.addAllToRunPath(runPath);
        }
    }

    protected final void run() throws TransactionException {
        ListIterator<TransactionRunnable> runPathIterator = this.getRunPath().listIterator();
        try {
            while (runPathIterator.hasNext()) {
                runPathIterator.next().onRun();
            }
        }
        catch (Throwable t) {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            errors.add(t);
            try {
                TransactionRunnable.rollbackAll(runPathIterator);
            }
            catch (TransactionException e) {
                errors.add(e);
            }
            try {
                this.complete();
            }
            catch (TransactionException e) {
                errors.add(e);
            }
            throw new TransactionException("Failure in onRun()", errors, false);
        }
    }

    protected final void commit() throws TransactionException {
        List<TransactionRunnable> runPath = this.getRunPath();
        ListIterator<TransactionRunnable> runPathReverseIterator = runPath.listIterator(runPath.size());
        try {
            while (runPathReverseIterator.hasPrevious()) {
                runPathReverseIterator.previous().onCommit();
            }
        }
        catch (Throwable t) {
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            errors.add(t);
            try {
                this.rollback();
            }
            catch (TransactionException e) {
                errors.add(e);
            }
            try {
                this.complete();
            }
            catch (TransactionException e) {
                errors.add(e);
            }
            throw new TransactionException("Failure in onCommit()", errors, false);
        }
    }

    protected final void rollback() throws TransactionException {
        List<TransactionRunnable> runPath = this.getRunPath();
        ListIterator<TransactionRunnable> runPathReverseIterator = runPath.listIterator(runPath.size());
        TransactionRunnable.rollbackAll(runPathReverseIterator);
    }

    protected final void complete() throws TransactionException {
        List<TransactionRunnable> runPath = this.getRunPath();
        ListIterator<TransactionRunnable> runPathReverseIterator = runPath.listIterator(runPath.size());
        TransactionRunnable.completeAll(runPathReverseIterator);
    }

    private static void completeAll(ListIterator<TransactionRunnable> iterator) throws TransactionException {
        ArrayList<ExceptionThrowingRunnable> list = new ArrayList<ExceptionThrowingRunnable>();
        while (iterator.hasPrevious()) {
            final TransactionRunnable runnable = iterator.previous();
            list.add(new ExceptionThrowingRunnable(){

                @Override
                public void run() throws Exception {
                    runnable.onComplete();
                }
            });
        }
        TransactionRunnable.doAllAndCollectThrowables(list, "Failure in onComplete() the storage engine should be consistant although it may contain uncollected garbage.", false);
    }

    private static void rollbackAll(ListIterator<TransactionRunnable> iterator) throws TransactionException {
        ArrayList<ExceptionThrowingRunnable> list = new ArrayList<ExceptionThrowingRunnable>();
        while (iterator.hasPrevious()) {
            final TransactionRunnable runnable = iterator.previous();
            list.add(new ExceptionThrowingRunnable(){

                @Override
                public void run() throws Exception {
                    runnable.onRollback();
                }
            });
        }
        TransactionRunnable.doAllAndCollectThrowables(list, "Failure in onRollback() the storage engine might be in an inconsistent state", true);
    }

    private static void doAllAndCollectThrowables(List<ExceptionThrowingRunnable> runnables, String message, boolean isNonRecoverable) throws TransactionException {
        ArrayList<Throwable> causes = null;
        for (ExceptionThrowingRunnable run : runnables) {
            try {
                run.run();
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new ArrayList<Throwable>();
                }
                causes.add(t);
            }
        }
        if (causes != null) {
            throw new TransactionException(message, causes, isNonRecoverable);
        }
    }

    private static interface ExceptionThrowingRunnable {
        public void run() throws Exception;
    }
}

