/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class TransactionException
extends Exception {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String TAB = "\t";
    private final List<Throwable> causes;
    private final boolean isNonRecoverable;
    private final int exceptionCount;

    public TransactionException(List<Throwable> causes) {
        this(null, causes);
    }

    public TransactionException(String message, List<Throwable> causes) {
        this(message, causes, false);
    }

    public TransactionException(String message, List<Throwable> causes, boolean isNonRecoverable) {
        super(message);
        this.causes = new ArrayList<Throwable>(causes);
        boolean nonRecoverable = isNonRecoverable;
        int total = 0;
        for (Throwable cause : this.causes) {
            if (cause instanceof TransactionException) {
                TransactionException teCause = (TransactionException)cause;
                total += teCause.exceptionCount();
                if (!teCause.isNonRecoverable()) continue;
                nonRecoverable = true;
                continue;
            }
            ++total;
        }
        this.exceptionCount = total;
        this.isNonRecoverable = nonRecoverable;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.causes.isEmpty() ? super.getCause() : this.causes.get(0);
    }

    public List<Throwable> getCauses() {
        return new ArrayList<Throwable>(this.causes);
    }

    public int exceptionCount() {
        return this.exceptionCount;
    }

    public boolean isNonRecoverable() {
        return this.isNonRecoverable;
    }

    @Override
    public String getMessage() {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        this.printInfo(printer, false);
        return ((Object)writer).toString();
    }

    public String getStackTraceString() {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        this.printStackTrace(printer);
        return ((Object)writer).toString();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream writeTo) {
        this.printStackTrace(new PrintWriter(writeTo));
    }

    @Override
    public void printStackTrace(PrintWriter writeTo) {
        this.printInfo(writeTo, true);
    }

    private void printInfo(PrintWriter writeTo, boolean includeStackTrace) {
        if (super.getMessage() != null) {
            writeTo.println(super.getMessage());
        }
        writeTo.println("Caused by:");
        for (Throwable cause : this.causes) {
            writeTo.println(cause.getClass().getName());
            writeTo.print(TAB);
            writeTo.print(cause.getMessage().replaceAll(NEWLINE, NEWLINE + TAB));
            writeTo.print(NEWLINE);
            if (!includeStackTrace) continue;
            StringWriter stw = new StringWriter();
            PrintWriter stpw = new PrintWriter(stw);
            cause.printStackTrace(stpw);
            writeTo.print(((Object)stw).toString().replaceAll(NEWLINE, NEWLINE + TAB));
        }
        if (includeStackTrace) {
            super.printStackTrace(writeTo);
        }
    }
}

