/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.merge.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.AttachmentDiff;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.ElementInterface;
import com.xpn.xwiki.objects.ObjectDiff;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.DiffManager;
import org.xwiki.diff.MergeConfiguration;
import org.xwiki.diff.MergeException;
import org.xwiki.diff.MergeResult;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.store.merge.MergeConflictDecisionsManager;
import org.xwiki.store.merge.MergeDocumentResult;
import org.xwiki.store.merge.MergeManager;
import org.xwiki.store.merge.MergeManagerResult;

@Component
@Singleton
public class DefaultMergeManager
implements MergeManager {
    private static final String ERROR_COLLISION_OBJECT = "Collision found on object [{}]";
    private static final String ERROR_COLLISION_OBJECT_PROPERTY = "Collision found on object property [{}]";
    private static final String ERROR_COLLISION_ATTACHMENT = "Collision found on attachment [{}]";
    private static final String WARNING_OBJECT_REMOVED = "Object [{}] already removed";
    @Inject
    private DiffManager diffManager;
    @Inject
    private MergeConflictDecisionsManager mergeConflictDecisionsManager;
    @Inject
    private Provider<XWikiContext> contextProvider;

    private <T> MergeConfiguration<T> getDefaultConfiguration(com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        EntityReference userReference = configuration.getUserReference();
        DocumentReference concernedDocument = configuration.getConcernedDocument();
        if (userReference != null && concernedDocument != null) {
            List conflictDecisionList = this.mergeConflictDecisionsManager.getConflictDecisionList(concernedDocument, userReference);
            if (conflictDecisionList != null) {
                return new MergeConfiguration(conflictDecisionList);
            }
            if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.CURRENT) {
                return new MergeConfiguration(MergeConfiguration.Version.CURRENT, Collections.emptyList());
            }
            if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.NEXT) {
                return new MergeConfiguration(MergeConfiguration.Version.NEXT, Collections.emptyList());
            }
        }
        return null;
    }

    private void cleanDecisionList(com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        EntityReference userReference = configuration.getUserReference();
        DocumentReference concernedDocument = configuration.getConcernedDocument();
        if (userReference != null && concernedDocument != null) {
            this.mergeConflictDecisionsManager.removeConflictDecisionList(concernedDocument, userReference);
        }
    }

    public MergeManagerResult<String, String> mergeLines(String previousStr, String newStr, String currentStr, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        MergeManagerResult mergeResult = new MergeManagerResult();
        try {
            MergeResult result = this.diffManager.merge(DefaultMergeManager.toLines(previousStr), DefaultMergeManager.toLines(newStr), DefaultMergeManager.toLines(currentStr), this.getDefaultConfiguration(configuration));
            mergeResult.getLog().addAll((Collection)result.getLog());
            mergeResult.addConflicts(result.getConflicts());
            String resultStr = DefaultMergeManager.fromLines(result.getMerged());
            mergeResult.setMergeResult((Object)resultStr);
            mergeResult.setModified(!resultStr.equals(currentStr));
        }
        catch (MergeException e) {
            mergeResult.getLog().error("Failed to execute merge lines", (Throwable)e);
        }
        return mergeResult;
    }

    public <T> MergeManagerResult<T, T> mergeObject(T previousObject, T newObject, T currentObject, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        MergeManagerResult mergeResult = new MergeManagerResult();
        if (ObjectUtils.notEqual(previousObject, newObject)) {
            if (ObjectUtils.equals(previousObject, currentObject)) {
                mergeResult.setMergeResult(newObject);
                mergeResult.setModified(true);
            } else if (ObjectUtils.equals(newObject, currentObject)) {
                mergeResult.setMergeResult(currentObject);
            } else {
                if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.CURRENT) {
                    mergeResult.setMergeResult(currentObject);
                } else if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.NEXT) {
                    mergeResult.setMergeResult(newObject);
                    mergeResult.setModified(true);
                }
                mergeResult.getLog().error("Failed to merge objects: previous=[{}] new=[{}] current=[{}]", new Object[]{previousObject, newObject, currentObject});
            }
        } else {
            mergeResult.setMergeResult(currentObject);
        }
        return mergeResult;
    }

    public MergeManagerResult<String, Character> mergeCharacters(String previousStr, String newStr, String currentStr, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        MergeManagerResult mergeResult = new MergeManagerResult();
        if (currentStr == null && newStr == null) {
            mergeResult.setMergeResult(null);
        } else {
            try {
                MergeResult result = this.diffManager.merge(DefaultMergeManager.toCharacters(previousStr), DefaultMergeManager.toCharacters(newStr), DefaultMergeManager.toCharacters(currentStr), this.getDefaultConfiguration(configuration));
                mergeResult.getLog().addAll((Collection)result.getLog());
                mergeResult.addConflicts(result.getConflicts());
                String resultStr = DefaultMergeManager.fromCharacters(result.getMerged());
                mergeResult.setMergeResult((Object)resultStr);
                mergeResult.setModified(!resultStr.equals(currentStr));
            }
            catch (MergeException e) {
                mergeResult.getLog().error("Failed to execute merge characters", (Throwable)e);
            }
        }
        return mergeResult;
    }

    public <T> MergeManagerResult<List<T>, T> mergeList(List<T> commonAncestor, List<T> next, List<T> current, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        MergeManagerResult mergeResult = new MergeManagerResult();
        try {
            MergeResult result = this.diffManager.merge(commonAncestor, next, current, this.getDefaultConfiguration(configuration));
            mergeResult.getLog().addAll((Collection)result.getLog());
            mergeResult.addConflicts(result.getConflicts());
            mergeResult.setMergeResult((Object)result.getMerged());
            mergeResult.setModified(!result.getMerged().equals(current));
        }
        catch (MergeException e) {
            mergeResult.getLog().error("Failed to execute merge lists", (Throwable)e);
        }
        return mergeResult;
    }

    public MergeDocumentResult mergeDocument(DocumentModelBridge previousDocument, DocumentModelBridge newDocument, DocumentModelBridge currentDocument, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        MergeDocumentResult mergeResult = new MergeDocumentResult(currentDocument, previousDocument, newDocument);
        if (previousDocument instanceof XWikiDocument && newDocument instanceof XWikiDocument && currentDocument instanceof XWikiDocument) {
            XWikiDocument previousDoc = (XWikiDocument)previousDocument;
            XWikiDocument newDoc = (XWikiDocument)newDocument;
            XWikiDocument currentDoc = (XWikiDocument)currentDocument;
            XWikiDocument mergedDocument = configuration.isProvidedVersionsModifiables() ? currentDoc : currentDoc.clone();
            mergeResult.setMergeResult((Object)mergedDocument);
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            configuration.setConcernedDocument(currentDoc.getDocumentReferenceWithLocale());
            configuration.setUserReference((EntityReference)context.getUserReference());
            MergeManagerResult<String, String> titleMergeResult = this.mergeObject(previousDocument.getTitle(), newDocument.getTitle(), currentDocument.getTitle(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.TITLE, titleMergeResult);
            mergedDocument.setTitle((String)titleMergeResult.getMergeResult());
            MergeManagerResult<String, String> contentMergeResult = this.mergeLines(previousDocument.getContent(), newDocument.getContent(), currentDocument.getContent(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.CONTENT, contentMergeResult);
            mergedDocument.setContent((String)contentMergeResult.getMergeResult());
            MergeManagerResult<Syntax, Syntax> syntaxMergeResult = this.mergeObject(previousDocument.getSyntax(), newDocument.getSyntax(), currentDocument.getSyntax(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.SYNTAX, syntaxMergeResult);
            mergedDocument.setSyntax((Syntax)syntaxMergeResult.getMergeResult());
            MergeManagerResult<Locale, Locale> localeMergeResult = this.mergeObject(previousDoc.getDefaultLocale(), newDoc.getDefaultLocale(), currentDoc.getDefaultLocale(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.DEFAULT_LOCALE, localeMergeResult);
            mergedDocument.setDefaultLocale((Locale)localeMergeResult.getMergeResult());
            MergeManagerResult<EntityReference, EntityReference> parentReferenceMergeResult = this.mergeObject(previousDoc.getRelativeParentReference(), newDoc.getRelativeParentReference(), currentDoc.getRelativeParentReference(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.PARENT_REFERENCE, parentReferenceMergeResult);
            mergedDocument.setParentReference((EntityReference)parentReferenceMergeResult.getMergeResult());
            MergeManagerResult<String, String> templateMergeResult = this.mergeObject(previousDoc.getDefaultTemplate(), newDoc.getDefaultTemplate(), currentDoc.getDefaultTemplate(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.DEFAULT_TEMPLATE, templateMergeResult);
            mergedDocument.setDefaultTemplate((String)templateMergeResult.getMergeResult());
            MergeManagerResult<Boolean, Boolean> hiddenPropertyMergeResult = this.mergeObject(previousDoc.isHidden(), newDoc.isHidden(), currentDoc.isHidden(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.HIDDEN, hiddenPropertyMergeResult);
            mergedDocument.setHidden((Boolean)hiddenPropertyMergeResult.getMergeResult());
            MergeManagerResult<Boolean, Boolean> enforceRequiredRightsMergeResult = this.mergeObject(previousDoc.isEnforceRequiredRights(), newDoc.isEnforceRequiredRights(), currentDoc.isEnforceRequiredRights(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.ENFORCE_REQUIRED_RIGHTS, enforceRequiredRightsMergeResult);
            mergedDocument.setEnforceRequiredRights(((Boolean)enforceRequiredRightsMergeResult.getMergeResult()).booleanValue());
            MergeManagerResult<String, String> customClassMergeResult = this.mergeLines(previousDoc.getCustomClass(), newDoc.getCustomClass(), currentDoc.getCustomClass(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.CUSTOM_CLASS, customClassMergeResult);
            mergedDocument.setCustomClass((String)customClassMergeResult.getMergeResult());
            MergeManagerResult<String, String> validationScriptMergeResult = this.mergeLines(previousDoc.getValidationScript(), newDoc.getValidationScript(), currentDoc.getValidationScript(), configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.VALIDATION_SCRIPT, validationScriptMergeResult);
            mergedDocument.setValidationScript((String)validationScriptMergeResult.getMergeResult());
            MergeManagerResult<Map<DocumentReference, List<BaseObject>>, BaseObject> objectMergeManagerResult = this.mergeXObjects(previousDoc, mergedDocument, newDoc, configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.XOBJECTS, objectMergeManagerResult);
            MergeManagerResult<ElementInterface, Object> classMergeManagerResult = this.mergeXClass(previousDoc, mergedDocument, newDoc, configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.XCLASS, classMergeManagerResult);
            MergeManagerResult<List<XWikiAttachment>, XWikiAttachment> attachmentMergeManagerResult = this.mergeAttachments(previousDoc, mergedDocument, newDoc, configuration);
            mergeResult.putMergeResult(MergeDocumentResult.DocumentPart.ATTACHMENTS, attachmentMergeManagerResult);
        } else {
            mergeResult.setMergeResult((Object)currentDocument);
            mergeResult.getLog().error("Cannot merge documents that are not of XWikiDocument class.");
        }
        this.cleanDecisionList(configuration);
        return mergeResult;
    }

    private MergeManagerResult<ElementInterface, Object> mergeXClass(XWikiDocument previousDoc, XWikiDocument mergedDocument, XWikiDocument newDoc, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        BaseClass classResult = mergedDocument.getXClass();
        BaseClass previousClass = previousDoc.getXClass();
        BaseClass newClass = newDoc.getXClass();
        return classResult.merge((ElementInterface)previousClass, (ElementInterface)newClass, configuration, context);
    }

    private MergeManagerResult<Map<DocumentReference, List<BaseObject>>, BaseObject> mergeXObjects(XWikiDocument previousDoc, XWikiDocument mergedDocument, XWikiDocument newDoc, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        MergeManagerResult objectMergeResult = new MergeManagerResult();
        objectMergeResult.setMergeResult((Object)mergedDocument.getXObjects());
        List objectsDiff = mergedDocument.getObjectDiff(previousDoc, newDoc, context);
        if (!objectsDiff.isEmpty()) {
            for (List objectClassDiff : objectsDiff) {
                for (ObjectDiff diff : objectClassDiff) {
                    PropertyInterface newProperty;
                    BaseObject objectResult = mergedDocument.getXObject(diff.getXClassReference(), diff.getNumber());
                    BaseObject previousObject = previousDoc.getXObject(diff.getXClassReference(), diff.getNumber());
                    BaseObject newObject = newDoc.getXObject(diff.getXClassReference(), diff.getNumber());
                    PropertyInterface propertyResult = objectResult != null ? objectResult.getField(diff.getPropName()) : null;
                    PropertyInterface previousProperty = previousObject != null ? previousObject.getField(diff.getPropName()) : null;
                    PropertyInterface propertyInterface = newProperty = newObject != null ? newObject.getField(diff.getPropName()) : null;
                    if (diff.getAction().equals("object-added")) {
                        if (objectResult == null) {
                            mergedDocument.setXObject(newObject.getNumber(), newObject.clone());
                            objectMergeResult.setModified(true);
                            continue;
                        }
                        if (!objectResult.equals((Object)newObject)) {
                            if (newObject != null && configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.NEXT) {
                                mergedDocument.setXObject(newObject.getNumber(), newObject.clone());
                                objectMergeResult.setModified(true);
                            }
                            objectMergeResult.getLog().error(ERROR_COLLISION_OBJECT, (Object)objectResult.getReference());
                            continue;
                        }
                        objectMergeResult.getLog().warn("Object [{}] already added", (Object)objectResult.getReference());
                        continue;
                    }
                    if (diff.getAction().equals("object-removed")) {
                        if (objectResult != null) {
                            if (objectResult.equals((Object)previousObject)) {
                                mergedDocument.removeXObject(objectResult);
                                objectMergeResult.setModified(true);
                                continue;
                            }
                            objectMergeResult.getLog().error(ERROR_COLLISION_OBJECT, (Object)objectResult.getReference());
                            continue;
                        }
                        objectMergeResult.getLog().warn(WARNING_OBJECT_REMOVED, (Object)previousObject.getReference());
                        continue;
                    }
                    if (previousObject == null || newObject == null) continue;
                    if (objectResult != null) {
                        if (diff.getAction().equals("added")) {
                            if (propertyResult == null) {
                                objectResult.safeput(diff.getPropName(), newProperty);
                                objectMergeResult.setModified(true);
                                continue;
                            }
                            if (!propertyResult.equals(newProperty)) {
                                if (configuration.getConflictFallbackVersion() == MergeConfiguration.ConflictFallbackVersion.NEXT) {
                                    objectResult.safeput(diff.getPropName(), newProperty);
                                    objectMergeResult.setModified(true);
                                }
                                objectMergeResult.getLog().error(ERROR_COLLISION_OBJECT_PROPERTY, (Object)propertyResult.getReference());
                                continue;
                            }
                            objectMergeResult.getLog().warn("Object property [{}] already added", (Object)propertyResult.getReference());
                            continue;
                        }
                        if (diff.getAction().equals("removed")) {
                            if (propertyResult != null) {
                                if (propertyResult.equals(previousProperty)) {
                                    objectResult.removeField(diff.getPropName());
                                    objectMergeResult.setModified(true);
                                    continue;
                                }
                                objectMergeResult.getLog().error(ERROR_COLLISION_OBJECT_PROPERTY, (Object)propertyResult.getReference());
                                continue;
                            }
                            objectMergeResult.getLog().warn("Object property [{}] already removed", (Object)previousProperty.getReference());
                            continue;
                        }
                        if (!diff.getAction().equals("changed")) continue;
                        if (propertyResult != null) {
                            if (propertyResult.equals(previousProperty)) {
                                objectResult.safeput(diff.getPropName(), newProperty);
                                objectMergeResult.setModified(true);
                                continue;
                            }
                            MergeManagerResult propertyManagerResult = propertyResult.merge((ElementInterface)previousProperty, (ElementInterface)newProperty, configuration, context);
                            objectMergeResult.getLog().addAll((Collection)propertyManagerResult.getLog());
                            if (!propertyManagerResult.isModified()) continue;
                            objectMergeResult.setModified(true);
                            objectResult.safeput(diff.getPropName(), (PropertyInterface)propertyManagerResult.getMergeResult());
                            continue;
                        }
                        objectMergeResult.getLog().warn("Property [{}] does not exist", (Object)newProperty.getReference());
                        objectResult.safeput(diff.getPropName(), newProperty);
                        objectMergeResult.setModified(true);
                        continue;
                    }
                    objectMergeResult.getLog().error(ERROR_COLLISION_OBJECT, (Object)previousObject.getReference());
                    if (configuration.getConflictFallbackVersion() != MergeConfiguration.ConflictFallbackVersion.NEXT) continue;
                    mergedDocument.setXObject(newObject.getNumber(), newObject.clone());
                    objectMergeResult.setModified(true);
                }
            }
        }
        return objectMergeResult;
    }

    private MergeManagerResult<List<XWikiAttachment>, XWikiAttachment> mergeAttachments(XWikiDocument previousDoc, XWikiDocument mergedDocument, XWikiDocument newDoc, com.xpn.xwiki.doc.merge.MergeConfiguration configuration) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        com.xpn.xwiki.doc.merge.MergeResult attachmentMergeResult = new com.xpn.xwiki.doc.merge.MergeResult();
        List attachmentsDiff = previousDoc.getAttachmentDiff(previousDoc, newDoc, context);
        if (!attachmentsDiff.isEmpty()) {
            for (AttachmentDiff diff : attachmentsDiff) {
                XWikiAttachment previousAttachment = diff.getOrigAttachment();
                XWikiAttachment nextAttachment = diff.getNewAttachment();
                XWikiAttachment attachment = mergedDocument.getAttachment(diff.getFileName());
                switch (diff.getType()) {
                    case DELETE: {
                        if (attachment != null) {
                            try {
                                if (attachment.equalsData(previousAttachment, context)) {
                                    mergedDocument.removeAttachment(attachment);
                                    attachmentMergeResult.setModified(true);
                                    break;
                                }
                                attachmentMergeResult.getLog().error(ERROR_COLLISION_ATTACHMENT, (Object)attachment.getReference());
                            }
                            catch (XWikiException e) {
                                attachmentMergeResult.getLog().error("Failed to compare attachments with reference [{}]", (Object)attachment.getReference());
                            }
                            break;
                        }
                        attachmentMergeResult.getLog().warn("Attachment [{}] already removed", (Object)previousAttachment.getReference());
                        break;
                    }
                    case INSERT: {
                        if (attachment != null) {
                            try {
                                if (!attachment.equalsData(nextAttachment, context)) {
                                    attachmentMergeResult.getLog().error(ERROR_COLLISION_ATTACHMENT, (Object)attachment.getReference());
                                    break;
                                }
                                attachmentMergeResult.getLog().warn("Attachment [{}] already added", (Object)nextAttachment.getReference());
                            }
                            catch (XWikiException e) {
                                attachmentMergeResult.getLog().error("Failed to compare attachments with reference [{}]", (Object)attachment.getReference());
                            }
                            break;
                        }
                        mergedDocument.addAttachment(nextAttachment);
                        attachmentMergeResult.setModified(true);
                        break;
                    }
                    case CHANGE: {
                        if (attachment != null) {
                            attachment.merge(previousAttachment, nextAttachment, configuration, context, attachmentMergeResult);
                            break;
                        }
                        attachmentMergeResult.getLog().error(ERROR_COLLISION_ATTACHMENT, (Object)previousAttachment.getReference());
                        if (configuration.getConflictFallbackVersion() != MergeConfiguration.ConflictFallbackVersion.NEXT) break;
                        mergedDocument.addAttachment(nextAttachment);
                        attachmentMergeResult.setModified(true);
                        break;
                    }
                }
            }
        }
        MergeManagerResult attachmentMergeManagerResult = new MergeManagerResult();
        attachmentMergeManagerResult.setMergeResult((Object)mergedDocument.getAttachmentList());
        attachmentMergeManagerResult.getLog().addAll((Collection)attachmentMergeResult.getLog());
        attachmentMergeManagerResult.setModified(attachmentMergeResult.isModified());
        return attachmentMergeManagerResult;
    }

    private static String fromLines(List<String> lines) {
        return StringUtils.join(lines, (char)'\n');
    }

    private static List<String> toLines(String str) {
        List result;
        try {
            result = IOUtils.readLines((Reader)new StringReader(str));
            if (str.endsWith("\n") || str.endsWith("\r") || str.endsWith("\r\n")) {
                result.add("");
            }
        }
        catch (UncheckedIOException e) {
            result = null;
        }
        return result;
    }

    private static String fromCharacters(List<Character> characters) {
        return StringUtils.join(characters, null);
    }

    private static List<Character> toCharacters(String str) {
        List<Character> characters;
        if (str != null) {
            characters = new ArrayList<Character>(str.length());
            for (char c : str.toCharArray()) {
                characters.add(Character.valueOf(c));
            }
        } else {
            characters = Collections.emptyList();
        }
        return characters;
    }
}

