/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.merge.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.diff.internal.DefaultConflictDecision;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.store.merge.MergeConflictDecisionsManager;

@Singleton
@Component
public class DefaultMergeConflictDecisionsManager
implements MergeConflictDecisionsManager {
    private Cache<Map<String, Conflict>> conflictsCache;
    private Map<String, List<ConflictDecision>> decisionMap = new HashMap<String, List<ConflictDecision>>();
    @Inject
    private CacheManager cacheManager;
    @Inject
    private EntityReferenceSerializer<String> stringEntityReferenceSerializer;
    @Inject
    private Logger logger;

    private void initCache() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setConfigurationId("xwiki.store.merge.conflictDecisionManager");
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(1000);
        lru.setLifespan(3600);
        cacheConfiguration.put((Object)"eviction", (Object)lru);
        try {
            this.conflictsCache = this.cacheManager.createNewCache(cacheConfiguration);
        }
        catch (CacheException e) {
            this.logger.error("Error when creating the cache of conflicts.", (Throwable)e);
        }
    }

    private Cache<Map<String, Conflict>> getConflictsCache() {
        if (this.conflictsCache == null) {
            this.initCache();
        }
        return this.conflictsCache;
    }

    private String getIdentifier(DocumentReference documentReference, EntityReference userReference) {
        return String.format("%s_%s", this.stringEntityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]), this.stringEntityReferenceSerializer.serialize(userReference, new Object[0]));
    }

    public List<ConflictDecision> getConflictDecisionList(DocumentReference documentReference, EntityReference userReference) {
        return this.decisionMap.get(this.getIdentifier(documentReference, userReference));
    }

    public void setConflictDecisionList(List<ConflictDecision> conflictDecisionList, DocumentReference documentReference, EntityReference userReference) {
        this.decisionMap.put(this.getIdentifier(documentReference, userReference), conflictDecisionList);
    }

    public void removeConflictDecisionList(DocumentReference documentReference, EntityReference userReference) {
        this.decisionMap.remove(this.getIdentifier(documentReference, userReference));
    }

    public void recordConflicts(DocumentReference documentReference, EntityReference userReference, List<Conflict<?>> conflicts) {
        HashMap conflictMap = new HashMap();
        if (conflicts != null) {
            for (Conflict<?> conflict : conflicts) {
                conflictMap.put(conflict.getReference(), conflict);
            }
        }
        this.getConflictsCache().set(this.getIdentifier(documentReference, userReference), conflictMap);
    }

    private void addDecision(String identifier, ConflictDecision conflictDecision) {
        List<Object> conflictDecisionList;
        if (this.decisionMap.containsKey(identifier)) {
            conflictDecisionList = this.decisionMap.get(identifier);
        } else {
            conflictDecisionList = new ArrayList();
            this.decisionMap.put(identifier, conflictDecisionList);
        }
        conflictDecisionList.add(conflictDecision);
    }

    public <E> boolean recordDecision(DocumentReference documentReference, EntityReference userReference, String conflictReference, ConflictDecision.DecisionType decisionType, List<E> customDecision) {
        String entryId = this.getIdentifier(documentReference, userReference);
        Map conflictMap = (Map)this.getConflictsCache().get(entryId);
        boolean decisionRecorded = false;
        if (conflictMap != null) {
            Conflict conflict = (Conflict)conflictMap.get(conflictReference);
            if (conflict != null) {
                DefaultConflictDecision conflictDecision = new DefaultConflictDecision(conflict);
                conflictDecision.setType(decisionType);
                if (customDecision != null && !customDecision.isEmpty()) {
                    conflictDecision.setCustom(customDecision);
                }
                this.addDecision(entryId, (ConflictDecision)conflictDecision);
                decisionRecorded = true;
            } else {
                this.logger.error("Cannot find a conflict with reference [{}] for document identifier [{}]", (Object)conflictReference, (Object)entryId);
            }
        } else {
            this.logger.error("Cannot find any conflict for document identifier [{}]", (Object)entryId);
        }
        return decisionRecorded;
    }
}

