/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.merge;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.util.Programming;
import java.util.List;
import org.xwiki.diff.Conflict;
import org.xwiki.store.merge.MergeDocumentResult;

public class MergeDocumentResultScript {
    private final MergeDocumentResult mergeDocumentResult;
    private final Document previousDocument;
    private final Document currentDocument;
    private final Document nextDocument;
    private final Document mergedDocument;
    private boolean hasProgramming;

    public MergeDocumentResultScript(MergeDocumentResult mergeDocumentResult, XWikiContext context) {
        this(mergeDocumentResult, context, false);
    }

    public MergeDocumentResultScript(MergeDocumentResult mergeDocumentResult, XWikiContext context, boolean hasProgramming) {
        this.mergeDocumentResult = mergeDocumentResult;
        this.previousDocument = ((XWikiDocument)mergeDocumentResult.getPreviousDocument()).newDocument(context);
        this.currentDocument = ((XWikiDocument)mergeDocumentResult.getCurrentDocument()).newDocument(context);
        this.nextDocument = ((XWikiDocument)mergeDocumentResult.getNextDocument()).newDocument(context);
        this.mergedDocument = ((XWikiDocument)mergeDocumentResult.getMergeResult()).newDocument(context);
        this.hasProgramming = hasProgramming;
    }

    public Document getPreviousDocument() {
        return this.previousDocument;
    }

    public Document getCurrentDocument() {
        return this.currentDocument;
    }

    public Document getNextDocument() {
        return this.nextDocument;
    }

    public Document getMergedDocument() {
        return this.mergedDocument;
    }

    public List<Conflict<?>> getContentConflicts() {
        return this.mergeDocumentResult.getConflicts(MergeDocumentResult.DocumentPart.CONTENT);
    }

    public List<Conflict<Object>> getAllConflicts() {
        return this.mergeDocumentResult.getConflicts();
    }

    @Programming
    public MergeDocumentResult getMergeDocumentResult() {
        if (this.hasProgramming) {
            return this.mergeDocumentResult;
        }
        return null;
    }

    public boolean hasOnlyContentConflicts() {
        return !this.getContentConflicts().isEmpty() && this.getContentConflicts().size() == this.mergeDocumentResult.getConflictsNumber();
    }
}

