/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.merge;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.diff.Conflict;
import org.xwiki.store.merge.MergeManagerResult;

public class MergeDocumentResult
extends MergeManagerResult<DocumentModelBridge, Object> {
    private final DocumentModelBridge currentDocument;
    private final DocumentModelBridge previousDocument;
    private final DocumentModelBridge nextDocument;
    private final Map<DocumentPart, MergeManagerResult> mergeResults;

    public MergeDocumentResult(DocumentModelBridge currentDocument, DocumentModelBridge previousDocument, DocumentModelBridge nextDocument) {
        this.currentDocument = currentDocument;
        this.previousDocument = previousDocument;
        this.nextDocument = nextDocument;
        this.mergeResults = new HashMap<DocumentPart, MergeManagerResult>();
    }

    public DocumentModelBridge getCurrentDocument() {
        return this.currentDocument;
    }

    public DocumentModelBridge getPreviousDocument() {
        return this.previousDocument;
    }

    public DocumentModelBridge getNextDocument() {
        return this.nextDocument;
    }

    public void putMergeResult(DocumentPart documentPart, MergeManagerResult mergeManagerResult) {
        if (this.mergeResults.containsKey((Object)documentPart)) {
            throw new IllegalArgumentException(String.format("The merge result of document part [%s] has already been put.", documentPart.name()));
        }
        this.mergeResults.put(documentPart, mergeManagerResult);
        this.getLog().addAll((Collection)mergeManagerResult.getLog());
        this.getConflicts().addAll(mergeManagerResult.getConflicts());
        this.setModified(this.isModified() || mergeManagerResult.isModified());
    }

    public MergeManagerResult getMergeResult(DocumentPart documentPart) {
        return this.mergeResults.get((Object)documentPart);
    }

    public List<Conflict<?>> getConflicts(DocumentPart documentPart) {
        if (this.mergeResults.containsKey((Object)documentPart)) {
            return this.mergeResults.get((Object)documentPart).getConflicts();
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeDocumentResult that = (MergeDocumentResult)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.currentDocument, (Object)that.currentDocument).append((Object)this.previousDocument, (Object)that.previousDocument).append((Object)this.nextDocument, (Object)that.nextDocument).append(this.mergeResults, that.mergeResults).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(95, 23).appendSuper(super.hashCode()).append((Object)this.currentDocument).append((Object)this.previousDocument).append((Object)this.nextDocument).append(this.mergeResults).toHashCode();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("currentDocument", (Object)this.currentDocument).append("previousDocument", (Object)this.previousDocument).append("nextDocument", (Object)this.nextDocument).append("mergeResults", this.mergeResults).toString();
    }

    public static enum DocumentPart {
        TITLE,
        CONTENT,
        SYNTAX,
        DEFAULT_LOCALE,
        PARENT_REFERENCE,
        DEFAULT_TEMPLATE,
        HIDDEN,
        CUSTOM_CLASS,
        VALIDATION_SCRIPT,
        XOBJECTS,
        XCLASS,
        ATTACHMENTS,
        ENFORCE_REQUIRED_RIGHTS;

    }
}

