/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.serialization.xml.internal;

import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.IOException;
import java.util.Date;
import javax.inject.Named;
import javax.inject.Singleton;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.xwiki.component.annotation.Component;
import org.xwiki.store.serialization.xml.internal.AbstractXMLSerializer;
import org.xwiki.store.serialization.xml.internal.XMLWriter;

@Component
@Named(value="attachment-meta/1.0")
@Singleton
public class AttachmentMetadataSerializer
extends AbstractXMLSerializer<XWikiAttachment, XWikiAttachment> {
    private static final String ROOT_ELEMENT_NAME = "attachment";
    private static final String SERIALIZER_PARAM = "serializer";
    private static final String THIS_SERIALIZER = "attachment-meta/1.0";
    private static final String FILENAME = "filename";
    private static final String FILESIZE = "filesize";
    private static final String AUTHOR = "author";
    private static final String VERSION = "version";
    private static final String COMMENT = "comment";
    private static final String DATE = "date";

    public XWikiAttachment parse(Element docel) throws IOException {
        if (!ROOT_ELEMENT_NAME.equals(docel.getName())) {
            throw new IOException("XML not recognizable as attachment metadata, expecting <attachment> tag");
        }
        if (docel.attribute(SERIALIZER_PARAM) == null || !THIS_SERIALIZER.equals(docel.attribute(SERIALIZER_PARAM).getValue())) {
            throw new IOException("Cannot parse this attachment metadata, it was saved with a different serializer.");
        }
        XWikiAttachment out = new XWikiAttachment();
        out.setFilename(docel.element(FILENAME).getText());
        out.setLongSize(Long.parseLong(docel.element(FILESIZE).getText()));
        out.setAuthor(docel.element(AUTHOR).getText());
        out.setVersion(docel.element(VERSION).getText());
        out.setComment(docel.element(COMMENT).getText());
        String sdate = docel.element(DATE).getText();
        Date date = new Date(Long.parseLong(sdate));
        out.setDate(date);
        return out;
    }

    public void serialize(XWikiAttachment attach, XMLWriter writer) throws IOException {
        DOMElement docel = new DOMElement(ROOT_ELEMENT_NAME);
        docel.addAttribute(SERIALIZER_PARAM, THIS_SERIALIZER);
        writer.writeOpen((Element)docel);
        writer.write(new DOMElement(FILENAME).addText(attach.getFilename()));
        writer.write(new DOMElement(FILESIZE).addText("" + attach.getLongSize()));
        writer.write(new DOMElement(AUTHOR).addText(attach.getAuthor()));
        writer.write(new DOMElement(VERSION).addText(attach.getVersion()));
        writer.write(new DOMElement(COMMENT).addText(attach.getComment()));
        writer.write(new DOMElement(DATE).addText("" + attach.getDate().getTime()));
        writer.writeClose((Element)docel);
    }
}

