/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.serialization.xml.internal;

import com.xpn.xwiki.doc.XWikiAttachment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.dom4j.Element;
import org.dom4j.dom.DOMElement;
import org.xwiki.component.annotation.Component;
import org.xwiki.store.serialization.xml.XMLSerializer;
import org.xwiki.store.serialization.xml.internal.AbstractXMLSerializer;
import org.xwiki.store.serialization.xml.internal.XMLWriter;

@Component
@Named(value="attachment-list-meta/1.0")
@Singleton
public class AttachmentListMetadataSerializer
extends AbstractXMLSerializer<List<XWikiAttachment>, List<XWikiAttachment>> {
    private static final String ROOT_ELEMENT_NAME = "attachment-list";
    private static final String SERIALIZER_PARAM = "serializer";
    private static final String THIS_SERIALIZER = "attachment-list-meta/1.0";
    @Inject
    @Named(value="attachment-meta/1.0")
    private XMLSerializer<XWikiAttachment, XWikiAttachment> attachSerializer;

    public AttachmentListMetadataSerializer() {
    }

    public AttachmentListMetadataSerializer(XMLSerializer<XWikiAttachment, XWikiAttachment> attachSerializer) {
        this.attachSerializer = attachSerializer;
    }

    public List<XWikiAttachment> parse(Element docel) throws IOException {
        if (!ROOT_ELEMENT_NAME.equals(docel.getName())) {
            throw new IOException("XML not recognizable as archive metadata, expecting <archive> tag");
        }
        if (!THIS_SERIALIZER.equals(docel.attribute(SERIALIZER_PARAM).getValue())) {
            throw new IOException("Cannot parse this attachment archive metadata, it was saved with a different serializer.");
        }
        ArrayList<XWikiAttachment> attachments = new ArrayList<XWikiAttachment>(docel.elements().size());
        for (Element attach : docel.elements()) {
            attachments.add((XWikiAttachment)this.attachSerializer.parse(attach));
        }
        return attachments;
    }

    public void serialize(List<XWikiAttachment> attachments, XMLWriter writer) throws IOException {
        DOMElement docel = new DOMElement(ROOT_ELEMENT_NAME);
        docel.addAttribute(SERIALIZER_PARAM, THIS_SERIALIZER);
        writer.writeOpen((Element)docel);
        for (XWikiAttachment attachment : attachments) {
            this.attachSerializer.serialize((Object)attachment, writer);
        }
        writer.writeClose((Element)docel);
    }
}

