/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDeletedDocumentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.XWikiRecycleBinContentStoreInterface;
import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.store.FileDeleteTransactionRunnable;
import org.xwiki.store.FileSaveTransactionRunnable;
import org.xwiki.store.FileSerializer;
import org.xwiki.store.TransactionRunnable;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.legacy.store.internal.DeletedDocumentContentFileSerializer;
import org.xwiki.store.legacy.store.internal.XWikiFileDeletedDocumentContent;
import org.xwiki.store.legacy.store.internal.XWikiHibernateTransaction;

@Component
@Named(value="file")
@Singleton
public class FilesystemRecycleBinContentStore
implements XWikiRecycleBinContentStoreInterface {
    @Inject
    private FilesystemStoreTools fileTools;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private Provider<DeletedDocumentContentFileSerializer> serializerProvider;

    public String getHint() {
        return "file";
    }

    public void save(XWikiDocument document, long index, boolean bTransaction) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiHibernateTransaction transaction = new XWikiHibernateTransaction(xcontext);
        File contentFile = this.fileTools.getDeletedDocumentFileProvider(document.getDocumentReferenceWithLocale(), index).getDeletedDocumentContentFile();
        DeletedDocumentContentFileSerializer serializer = (DeletedDocumentContentFileSerializer)this.serializerProvider.get();
        serializer.init(document, StandardCharsets.UTF_8.name());
        new FileSaveTransactionRunnable(contentFile, this.fileTools.getTempFile(contentFile), this.fileTools.getBackupFile(contentFile), this.fileTools.getLockForFile(contentFile), (FileSerializer)serializer).runIn((TransactionRunnable)transaction);
        try {
            transaction.start();
        }
        catch (Exception e) {
            throw new XWikiException(3, 3232, "Exception while saving deleted document content.", (Throwable)e);
        }
    }

    public XWikiDeletedDocumentContent get(DocumentReference reference, long index, boolean bTransaction) throws XWikiException {
        File contentFile = this.fileTools.getDeletedDocumentFileProvider(reference, index).getDeletedDocumentContentFile();
        if (contentFile.exists()) {
            return new XWikiFileDeletedDocumentContent(contentFile, StandardCharsets.UTF_8);
        }
        return null;
    }

    public void delete(DocumentReference reference, long index, boolean bTransaction) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiHibernateTransaction transaction = new XWikiHibernateTransaction(xcontext);
        File contentFile = this.fileTools.getDeletedDocumentFileProvider(reference, index).getDeletedDocumentContentFile();
        new FileDeleteTransactionRunnable(contentFile, this.fileTools.getBackupFile(contentFile), this.fileTools.getLockForFile(contentFile)).runIn((TransactionRunnable)transaction);
        try {
            transaction.start();
        }
        catch (Exception e) {
            throw new XWikiException(3, 3232, "Exception while deleting deleted document content.", (Throwable)e);
        }
    }
}

