/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.internal.doc.ListAttachmentArchive;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.store.StartableTransactionRunnable;
import org.xwiki.store.filesystem.internal.AttachmentFileProvider;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.legacy.doc.internal.FilesystemAttachmentContent;
import org.xwiki.store.legacy.store.internal.AttachmentArchiveDeleteRunnable;
import org.xwiki.store.legacy.store.internal.AttachmentArchiveSaveRunnable;
import org.xwiki.store.serialization.Serializer;

@Component
@Named(value="file")
@Singleton
public class FilesystemAttachmentVersioningStore
implements AttachmentVersioningStore {
    private static final String UNKNOWN_NAME = "UNKNOWN";
    @Inject
    private FilesystemStoreTools fileTools;
    @Inject
    @Named(value="attachment-list-meta/1.0")
    private Serializer<List<XWikiAttachment>, List<XWikiAttachment>> metaSerializer;

    public String getHint() {
        return "file";
    }

    public XWikiAttachmentArchive loadArchive(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        try {
            return this.loadArchive(attachment, this.fileTools.getAttachmentFileProvider(attachment.getReference()));
        }
        catch (Exception e) {
            if (e instanceof XWikiException) {
                throw (XWikiException)((Object)e);
            }
            Object[] args = new Object[]{attachment.getFilename(), UNKNOWN_NAME};
            if (attachment.getDoc() != null) {
                args[1] = attachment.getDoc().getFullName();
            }
            throw new XWikiException(3, 0, "Exception while loading attachment archive {0} for document {1}", (Throwable)e, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XWikiAttachmentArchive loadArchive(XWikiAttachment attachment, AttachmentFileProvider provider) throws IOException {
        List attachList;
        File metaFile = provider.getAttachmentVersioningMetaFile();
        if (!metaFile.exists()) {
            return new ListAttachmentArchive(attachment);
        }
        ReadWriteLock lock = this.fileTools.getLockForFile(metaFile);
        lock.readLock().lock();
        try {
            FileInputStream is = new FileInputStream(metaFile);
            attachList = (List)this.metaSerializer.parse((InputStream)is);
            ((InputStream)is).close();
        }
        finally {
            lock.readLock().unlock();
        }
        for (XWikiAttachment attach : attachList) {
            File contentFile = provider.getAttachmentVersionContentFile(attach.getVersion());
            attach.setAttachment_content((XWikiAttachmentContent)new FilesystemAttachmentContent(contentFile, attach));
            attach.setContentStore("file");
            attach.setDoc(attachment.getDoc(), false);
        }
        ListAttachmentArchive out = new ListAttachmentArchive(attachList);
        out.setAttachment(attachment);
        return out;
    }

    public void saveArchive(XWikiAttachmentArchive archive, XWikiContext context, boolean bTransaction) throws XWikiException {
        try {
            this.getArchiveSaveRunnable(archive, context).start();
        }
        catch (Exception e) {
            if (e instanceof XWikiException) {
                throw (XWikiException)((Object)e);
            }
            Object[] args = new Object[]{UNKNOWN_NAME, UNKNOWN_NAME};
            if (archive.getAttachment() != null) {
                args[0] = archive.getAttachment().getFilename();
                if (archive.getAttachment().getDoc() != null) {
                    args[1] = archive.getAttachment().getDoc().getFullName();
                }
            }
            throw new XWikiException(3, 0, "Exception while saving attachment archive {0} of document {1}", (Throwable)e, args);
        }
    }

    public StartableTransactionRunnable getArchiveSaveRunnable(XWikiAttachmentArchive archive, XWikiContext context) throws XWikiException {
        return new AttachmentArchiveSaveRunnable(archive, this.fileTools, this.fileTools.getAttachmentFileProvider(archive.getAttachment().getReference()), this.metaSerializer, context);
    }

    public void deleteArchive(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        if (attachment == null) {
            throw new NullPointerException("The attachment to delete cannot be null");
        }
        try {
            XWikiAttachmentArchive archive = this.loadArchive(attachment, context, bTransaction);
            this.getArchiveDeleteRunnable(archive).start();
        }
        catch (Exception e) {
            if (e instanceof XWikiException) {
                throw (XWikiException)((Object)e);
            }
            Object[] args = new Object[]{attachment.getFilename(), UNKNOWN_NAME};
            if (attachment.getDoc() != null) {
                args[1] = attachment.getDoc().getFullName();
            }
            throw new XWikiException(3, 0, "Exception while deleting attachment archive {0} from document {1}", (Throwable)e, args);
        }
    }

    public StartableTransactionRunnable getArchiveDeleteRunnable(XWikiAttachmentArchive archive) {
        if (archive == null) {
            throw new NullPointerException("The archive to delete cannot be null.");
        }
        if (archive.getAttachment() == null) {
            throw new IllegalArgumentException("Cannot delete an archive unless it is associated with an attachment.");
        }
        return new AttachmentArchiveDeleteRunnable(archive, this.fileTools, this.fileTools.getAttachmentFileProvider(archive.getAttachment().getReference()));
    }
}

