/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.doc.ListAttachmentArchive;
import com.xpn.xwiki.store.AttachmentVersioningStore;
import com.xpn.xwiki.store.XWikiAttachmentStoreInterface;
import com.xpn.xwiki.store.XWikiStoreInterface;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.store.FileDeleteTransactionRunnable;
import org.xwiki.store.FileSaveTransactionRunnable;
import org.xwiki.store.StreamProvider;
import org.xwiki.store.StringStreamProvider;
import org.xwiki.store.TransactionRunnable;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.filesystem.internal.StoreFileUtils;
import org.xwiki.store.legacy.doc.internal.FilesystemAttachmentContent;
import org.xwiki.store.legacy.store.internal.AttachmentContentStreamProvider;
import org.xwiki.store.legacy.store.internal.FilesystemAttachmentVersioningStore;
import org.xwiki.store.legacy.store.internal.HibernateTransaction;
import org.xwiki.store.legacy.store.internal.XWikiHibernateTransaction;

@Component
@Named(value="file")
@Singleton
public class FilesystemAttachmentStore
implements XWikiAttachmentStoreInterface {
    @Inject
    private FilesystemStoreTools fileTools;
    @Inject
    @Named(value="hibernate")
    private AttachmentVersioningStore hibernateAttachmentVersioningStore;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public String getHint() {
        return "file";
    }

    public void saveAttachmentContent(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.saveAttachmentContent(attachment, true, context, bTransaction);
    }

    public void saveAttachmentContent(XWikiAttachment attachment, boolean updateDocument, XWikiContext context, boolean bTransaction) throws XWikiException {
        XWikiHibernateTransaction transaction = new XWikiHibernateTransaction(context);
        this.getAttachmentContentSaveRunnable(attachment, updateDocument, context).runIn((TransactionRunnable)transaction);
        try {
            transaction.start();
        }
        catch (Exception e) {
            throw new XWikiException(3, 3232, "Exception while saving attachment.", (Throwable)e);
        }
    }

    private TransactionRunnable<XWikiHibernateTransaction> getAttachmentContentSaveRunnable(XWikiAttachment attachment, boolean updateDocument, XWikiContext context) throws XWikiException {
        XWikiAttachmentContent content = attachment.getAttachment_content();
        if (content == null) {
            return new TransactionRunnable();
        }
        File attachFile = this.fileTools.getAttachmentFileProvider(attachment.getReference()).getAttachmentContentFile();
        return new AttachmentSaveTransactionRunnable(attachment, updateDocument, context, attachFile);
    }

    public void saveAttachmentsContent(List<XWikiAttachment> attachments, final XWikiDocument doc, boolean updateDocument, final XWikiContext context, boolean bTransaction) throws XWikiException {
        if (attachments == null || attachments.isEmpty()) {
            return;
        }
        try {
            XWikiHibernateTransaction transaction = new XWikiHibernateTransaction(context);
            for (XWikiAttachment attach : attachments) {
                this.getAttachmentContentSaveRunnable(attach, false, context).runIn((TransactionRunnable)transaction);
            }
            if (updateDocument) {
                new TransactionRunnable<XWikiHibernateTransaction>(){

                    protected void onRun() throws Exception {
                        context.getWiki().getStore().saveXWikiDoc(doc, context, false);
                    }
                }.runIn((TransactionRunnable)transaction);
            }
            transaction.start();
        }
        catch (XWikiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XWikiException(3, 3232, "Exception while saving attachments", (Throwable)e);
        }
    }

    public void loadAttachmentContent(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        File attachFile = this.fileTools.getAttachmentFileProvider(attachment.getReference()).getAttachmentContentFile();
        try {
            attachFile = StoreFileUtils.resolve(attachFile, true);
        }
        catch (IOException e) {
            throw new XWikiException(3, 3006, "Failed to resolve the attachment file link for file [{0}]", (Throwable)e, new Object[]{attachFile});
        }
        if (!attachFile.exists()) {
            throw new XWikiException(3, 3002, String.format("The attachment [%s] (file %s) could not be found in the filesystem attachment store.", attachment.getReference(), attachFile));
        }
        FilesystemAttachmentContent content = new FilesystemAttachmentContent(attachFile);
        content.setContentDirty(false);
        attachment.setAttachment_content((XWikiAttachmentContent)content);
        attachment.setContentStore("file");
    }

    public boolean attachmentContentExists(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        File attachFile;
        try {
            attachFile = StoreFileUtils.resolve(this.fileTools.getAttachmentFileProvider(attachment.getReference()).getAttachmentContentFile(), false);
        }
        catch (IOException e) {
            throw new XWikiException(3, 3006, "Failed to resolve the attachment file link", (Throwable)e);
        }
        return attachFile.exists();
    }

    public void deleteXWikiAttachment(XWikiAttachment attachment, XWikiContext context, boolean bTransaction) throws XWikiException {
        this.deleteXWikiAttachment(attachment, true, context, bTransaction);
    }

    public void deleteXWikiAttachment(XWikiAttachment attachment, boolean parentUpdate, XWikiContext context, boolean bTransaction) throws XWikiException {
        XWikiHibernateTransaction transaction = new XWikiHibernateTransaction(context);
        this.getAttachmentDeleteRunnable(attachment, parentUpdate, context).runIn((TransactionRunnable)transaction);
        try {
            transaction.start();
        }
        catch (Exception e) {
            throw new XWikiException(3, 0, "Exception while deleting attachment.", (Throwable)e);
        }
    }

    private TransactionRunnable<XWikiHibernateTransaction> getAttachmentDeleteRunnable(XWikiAttachment attachment, boolean updateDocument, XWikiContext context) throws XWikiException {
        File attachFile = this.fileTools.getAttachmentFileProvider(attachment.getReference()).getAttachmentContentFile();
        return new AttachmentDeleteTransactionRunnable(attachment, updateDocument, context, attachFile);
    }

    public void cleanUp(XWikiContext context) {
    }

    private AttachmentVersioningStore resolveAttachmentVersioningStore(XWikiAttachment attachment, XWikiContext xcontext) {
        if (!attachment.isArchiveStoreSet()) {
            return xcontext.getWiki().getDefaultAttachmentArchiveStore();
        }
        AttachmentVersioningStore store = this.getAttachmentVersioningStore(attachment.getArchiveStore());
        return store != null ? store : this.hibernateAttachmentVersioningStore;
    }

    private AttachmentVersioningStore getAttachmentVersioningStore(String storeType) {
        if (storeType != null && !storeType.equals("hibernate")) {
            try {
                return (AttachmentVersioningStore)this.componentManager.getInstance(AttachmentVersioningStore.class, storeType);
            }
            catch (ComponentLookupException e) {
                this.logger.warn("Can't find attachment versionning store for type [{}]", (Object)storeType, (Object)e);
            }
        }
        return null;
    }

    private class AttachmentSaveTransactionRunnable
    extends TransactionRunnable<XWikiHibernateTransaction> {
        AttachmentSaveTransactionRunnable(final XWikiAttachment attachment, boolean updateDocument, final XWikiContext context, File attachFile) throws XWikiException {
            File otherAttachFile;
            AttachmentContentStreamProvider streamProvider;
            File finalAttachFile;
            boolean link = false;
            final AttachmentVersioningStore avs = FilesystemAttachmentStore.this.resolveAttachmentVersioningStore(attachment, context);
            if (avs instanceof FilesystemAttachmentVersioningStore) {
                FilesystemAttachmentVersioningStore favs = (FilesystemAttachmentVersioningStore)avs;
                XWikiAttachmentArchive archive = attachment.getAttachment_archive();
                if (archive == null) {
                    archive = new ListAttachmentArchive(attachment);
                    link = true;
                } else {
                    XWikiAttachment archiveAttachment = archive.getRevision(attachment, attachment.getVersion(), context);
                    if (archiveAttachment != null && archiveAttachment.getDate() == attachment.getDate() && archiveAttachment.getLongSize() == attachment.getLongSize()) {
                        link = true;
                    }
                }
                favs.getArchiveSaveRunnable(archive, context).runIn((TransactionRunnable)this);
            } else {
                new TransactionRunnable<XWikiHibernateTransaction>(){

                    protected void onRun() throws XWikiException {
                        avs.saveArchive(attachment.getAttachment_archive(), context, false);
                    }
                }.runIn((TransactionRunnable)this);
            }
            File linkAttachFile = StoreFileUtils.getLinkFile(attachFile);
            if (link) {
                finalAttachFile = linkAttachFile;
                streamProvider = new StringStreamProvider(FilesystemAttachmentStore.this.fileTools.getLinkContent(attachment), StandardCharsets.UTF_8);
                otherAttachFile = attachFile;
            } else {
                finalAttachFile = attachFile;
                streamProvider = new AttachmentContentStreamProvider(attachment, context);
                otherAttachFile = linkAttachFile;
            }
            new FileSaveTransactionRunnable(finalAttachFile, FilesystemAttachmentStore.this.fileTools.getTempFile(finalAttachFile), FilesystemAttachmentStore.this.fileTools.getBackupFile(finalAttachFile), FilesystemAttachmentStore.this.fileTools.getLockForFile(finalAttachFile), (StreamProvider)streamProvider).runIn((TransactionRunnable)this);
            new FileDeleteTransactionRunnable(otherAttachFile, FilesystemAttachmentStore.this.fileTools.getTempFile(otherAttachFile), FilesystemAttachmentStore.this.fileTools.getLockForFile(otherAttachFile)).runIn((TransactionRunnable)this);
            if (updateDocument) {
                final XWikiStoreInterface store = context.getWiki().getStore();
                final XWikiDocument doc = attachment.getDoc();
                new TransactionRunnable<XWikiHibernateTransaction>(){

                    protected void onRun() throws XWikiException {
                        store.saveXWikiDoc(doc, context, false);
                    }
                }.runIn((TransactionRunnable)this);
            }
        }
    }

    private class AttachmentDeleteTransactionRunnable
    extends TransactionRunnable<XWikiHibernateTransaction> {
        private final XWikiAttachment attachment;
        private final boolean updateDocument;
        private final XWikiContext context;

        AttachmentDeleteTransactionRunnable(final XWikiAttachment attachment, boolean updateDocument, final XWikiContext context, File attachFile) throws XWikiException {
            File linkAtachFile = StoreFileUtils.getLinkFile(attachFile);
            new FileDeleteTransactionRunnable(attachFile, FilesystemAttachmentStore.this.fileTools.getBackupFile(attachFile), FilesystemAttachmentStore.this.fileTools.getLockForFile(attachFile)).runIn((TransactionRunnable)this);
            new FileDeleteTransactionRunnable(linkAtachFile, FilesystemAttachmentStore.this.fileTools.getBackupFile(linkAtachFile), FilesystemAttachmentStore.this.fileTools.getLockForFile(linkAtachFile)).runIn((TransactionRunnable)this);
            final AttachmentVersioningStore avs = context.getWiki().getDefaultAttachmentArchiveStore();
            if (avs instanceof FilesystemAttachmentVersioningStore) {
                FilesystemAttachmentVersioningStore favs = (FilesystemAttachmentVersioningStore)avs;
                favs.getArchiveDeleteRunnable(attachment.loadArchive(context)).runIn((TransactionRunnable)this);
            } else {
                new TransactionRunnable<HibernateTransaction>(){

                    protected void onRun() throws XWikiException {
                        avs.deleteArchive(attachment, context, false);
                    }
                }.runIn((TransactionRunnable)this);
            }
            this.context = context;
            this.attachment = attachment;
            this.updateDocument = updateDocument;
        }

        protected void onRun() throws Exception {
            Session session = this.context.getWiki().getHibernateStore().getSession(this.context);
            session.delete((Object)new XWikiAttachmentContent(this.attachment));
            if (this.updateDocument) {
                String filename = this.attachment.getFilename();
                List list = this.attachment.getDoc().getAttachmentList();
                for (int i = 0; i < list.size(); ++i) {
                    if (!filename.equals(((XWikiAttachment)list.get(i)).getFilename())) continue;
                    list.remove(i);
                    break;
                }
                this.context.getWiki().getStore().saveXWikiDoc(this.attachment.getDoc(), this.context, false);
            }
            session.delete((Object)this.attachment);
        }
    }
}

