/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.legacy.store.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentArchive;
import com.xpn.xwiki.store.VoidAttachmentVersioningStore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.store.FileSaveTransactionRunnable;
import org.xwiki.store.StartableTransactionRunnable;
import org.xwiki.store.StreamProvider;
import org.xwiki.store.TransactionRunnable;
import org.xwiki.store.filesystem.internal.AttachmentFileProvider;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.legacy.store.internal.AttachmentContentStreamProvider;
import org.xwiki.store.serialization.SerializationStreamProvider;
import org.xwiki.store.serialization.Serializer;

public class AttachmentArchiveSaveRunnable
extends StartableTransactionRunnable {
    public AttachmentArchiveSaveRunnable(XWikiAttachmentArchive archive, FilesystemStoreTools fileTools, AttachmentFileProvider provider, Serializer<List<XWikiAttachment>, List<XWikiAttachment>> serializer, XWikiContext context) throws XWikiException {
        if (archive instanceof VoidAttachmentVersioningStore.VoidAttachmentArchive) {
            return;
        }
        if (archive.getVersions().length == 0 && archive.getAttachment() != null) {
            archive.addCurrentAttachment(context);
        }
        Version[] versions = archive.getVersions();
        ArrayList<XWikiAttachment> attachmentVersions = new ArrayList<XWikiAttachment>(versions.length);
        for (int i = 0; i < versions.length; ++i) {
            String versionName = versions[i].toString();
            XWikiAttachment attachVer = archive.getRevision(archive.getAttachment(), versionName, context);
            attachmentVersions.add(attachVer);
            if (!attachVer.isContentDirty() && provider.getAttachmentVersionContentFile(versionName).exists()) continue;
            AttachmentContentStreamProvider contentProvider = new AttachmentContentStreamProvider(attachVer, context);
            this.addSaver(contentProvider, fileTools, provider.getAttachmentVersionContentFile(versionName));
        }
        SerializationStreamProvider metaProvider = new SerializationStreamProvider(serializer, attachmentVersions);
        this.addSaver((StreamProvider)metaProvider, fileTools, provider.getAttachmentVersioningMetaFile());
    }

    private void addSaver(StreamProvider provider, FilesystemStoreTools fileTools, File saveHere) {
        new FileSaveTransactionRunnable(saveHere, fileTools.getTempFile(saveHere), fileTools.getBackupFile(saveHere), fileTools.getLockForFile(saveHere), provider).runIn((TransactionRunnable)this);
    }
}

