/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.store.migration.XWikiDBVersion;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.store.filesystem.internal.migration.AbstractXWIKI14697DataMigration;

@Component
@Named(value="R910000XWIKI14697")
@Singleton
public class R910000XWIKI14697DataMigration
extends AbstractXWIKI14697DataMigration {
    public R910000XWIKI14697DataMigration() {
        super("XWikiAttachmentContent", "contentStore");
    }

    public String getDescription() {
        return "Make sure all attachments have the right content store id.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(910000);
    }

    @Override
    protected boolean isFile(AttachmentReference attachmentReference) {
        File attachmentFolder = this.getAttachmentDir(attachmentReference);
        try {
            return new File(attachmentFolder, URLEncoder.encode(attachmentReference.getName(), "UTF8")).exists();
        }
        catch (UnsupportedEncodingException e) {
            throw new HibernateException("UTF8 is unknown", (Throwable)e);
        }
    }
}

