/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.store.filesystem.internal.migration.AbstractFileStoreDataMigration;

public abstract class AbstractStoreTypeDataMigration
extends AbstractFileStoreDataMigration {
    @Inject
    protected DocumentReferenceResolver<String> resolver;
    protected final String tableName;
    protected final String updateQuery;

    public AbstractStoreTypeDataMigration(String tableName, String fieldName) {
        this.tableName = tableName;
        this.updateQuery = "UPDATE XWikiAttachment SET " + fieldName + " = :store WHERE id IN (:ids)";
    }

    public void hibernateMigrate() throws XWikiException, DataMigrationException {
        this.getStore().executeWrite(this.getXWikiContext(), (XWikiHibernateBaseStore.HibernateCallback)new XWikiHibernateBaseStore.HibernateCallback<Void>(){

            public Void doInHibernate(Session session) throws HibernateException {
                AbstractStoreTypeDataMigration.this.doWork(session);
                return null;
            }
        });
    }

    protected void doWork(Session session) {
        Query selectQuery = session.createQuery("SELECT attachment.id, attachment.filename, document.fullName FROM XWikiAttachment as attachment, XWikiDocument as document WHERE attachment.docId = document.id AND attachment.id NOT IN (SELECT id FROM " + this.tableName + ")");
        List attachments = selectQuery.list();
        if (!attachments.isEmpty()) {
            this.setStore(attachments, session);
        }
    }

    private void setStore(List<Object[]> attachments, Session session) {
        WikiReference wikiReference = this.getXWikiContext().getWikiReference();
        ArrayList<Long> fileAttachments = new ArrayList<Long>(attachments.size());
        ArrayList<Long> otherAttachments = new ArrayList<Long>(attachments.size());
        for (Object[] attachment : attachments) {
            Long id = (Long)attachment[0];
            String filename = (String)attachment[1];
            String fullName = (String)attachment[2];
            DocumentReference documentReference = this.resolver.resolve((Object)fullName, new Object[]{wikiReference});
            AttachmentReference attachmentReference = new AttachmentReference(filename, documentReference);
            if (this.isFile(attachmentReference)) {
                fileAttachments.add(id);
                continue;
            }
            otherAttachments.add(id);
        }
        this.setStore(session, fileAttachments, "file");
        this.setOtherStore(otherAttachments, session);
    }

    protected void setOtherStore(List<Long> otherAttachments, Session session) {
    }

    protected abstract boolean isFile(AttachmentReference var1);

    protected void setStore(Session session, List<Long> values, String store) {
        if (!values.isEmpty()) {
            Query query = session.createQuery(this.updateQuery);
            query.setParameter("store", (Object)store);
            query.setParameterList("ids", values);
            query.executeUpdate();
        }
    }
}

