/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal.migration;

import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;
import org.xwiki.store.internal.FileSystemStoreUtils;

public abstract class AbstractFileStoreDataMigration
extends AbstractHibernateDataMigration
implements Initializable {
    protected static final String THIS_DIR_NAME = "~this";
    protected static final String DOCUMENT_LOCALE_ROOT_NAME = "~";
    @Inject
    protected Environment environment;
    @Inject
    protected FilesystemStoreTools fstools;
    @Inject
    protected Logger logger;
    protected File pre11StoreRootDirectory;
    protected File storeRootDirectory;

    public void initialize() throws InitializationException {
        this.pre11StoreRootDirectory = new File(this.environment.getPermanentDirectory(), "storage");
        this.storeRootDirectory = this.getVersion().getVersion() < 1100000 ? this.pre11StoreRootDirectory : this.fstools.getStoreRootDirectory();
    }

    protected File getPre11StoreRootDirectory() {
        return this.pre11StoreRootDirectory;
    }

    protected File getStoreRootDirectory() {
        return this.storeRootDirectory;
    }

    protected void setStoreRootDirectory(File storeRootDirectory) {
        this.storeRootDirectory = storeRootDirectory;
    }

    protected File getPre11WikiDir(String wikiId) {
        return new File(this.getPre11StoreRootDirectory(), wikiId);
    }

    private EntityReference getPre11EntityReference(File directory) throws IOException {
        String name = FileSystemStoreUtils.decode((String)directory.getName());
        File parent = directory.getParentFile();
        if (parent.getCanonicalPath().equals(this.getStoreRootDirectory().getCanonicalPath())) {
            return new WikiReference(name);
        }
        return new SpaceReference(name, this.getPre11EntityReference(parent));
    }

    protected DocumentReference getPre11DocumentReference(File directory) throws DataMigrationException {
        try {
            String name = FileSystemStoreUtils.decode((String)directory.getName());
            return new DocumentReference(name, (SpaceReference)this.getPre11EntityReference(directory.getParentFile()));
        }
        catch (Exception e) {
            throw new DataMigrationException("Failed to get document reference for filesystem path [" + String.valueOf(directory) + "] (root=" + String.valueOf(this.getStoreRootDirectory()) + ")", (Throwable)e);
        }
    }

    protected void moveFolderContent(File sourceFolder, File toFolder) throws DataMigrationException {
        this.logger.info("Moving content of folder [{}] to new location [{}]", (Object)sourceFolder, (Object)toFolder);
        for (File child : sourceFolder.listFiles()) {
            try {
                FileUtils.moveToDirectory((File)child, (File)toFolder, (boolean)true);
            }
            catch (IOException e) {
                throw new DataMigrationException("Failed to move content of folder [" + String.valueOf(sourceFolder) + "] the new location [" + String.valueOf(toFolder) + "]", (Throwable)e);
            }
        }
    }
}

