/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.store.filesystem.internal.FilesystemStoreTools;

@Component
@Named(value="org.xwiki.store.filesystem.internal.WikiDeletedListener")
@Singleton
public class WikiDeletedListener
extends AbstractEventListener {
    public static final String NAME = "org.xwiki.store.filesystem.internal.WikiDeletedListener";
    @Inject
    private FilesystemStoreTools store;
    @Inject
    private Logger logger;

    public WikiDeletedListener() {
        super(NAME, new Event[]{new WikiDeletedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        String wikiId = ((WikiDeletedEvent)event).getWikiId();
        File directory = this.store.getWikiDir(wikiId);
        if (directory.exists() && directory.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)directory);
            }
            catch (IOException e) {
                this.logger.error("Failed to delete storage for the wiki [{}]", (Object)wikiId, (Object)e);
            }
        }
    }
}

