/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal;

import com.xpn.xwiki.doc.XWikiAttachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.DocumentReference;

public class TemporaryAttachmentSession
implements HttpSessionBindingListener {
    private final String sessionId;
    private final Map<DocumentReference, Map<String, XWikiAttachment>> editionsMap;

    public TemporaryAttachmentSession(String sessionId) {
        this.sessionId = sessionId;
        this.editionsMap = new ConcurrentHashMap<DocumentReference, Map<String, XWikiAttachment>>();
    }

    public void addAttachment(DocumentReference documentReference, XWikiAttachment attachment) {
        Map<Object, Object> attachmentMap;
        if (!this.editionsMap.containsKey(documentReference)) {
            attachmentMap = new ConcurrentHashMap();
            this.editionsMap.put(documentReference, attachmentMap);
        } else {
            attachmentMap = this.editionsMap.get(documentReference);
        }
        attachmentMap.put(attachment.getFilename(), attachment);
    }

    public void dispose() {
        this.editionsMap.values().forEach(stringXWikiAttachmentMap -> stringXWikiAttachmentMap.values().forEach(attachment -> attachment.getAttachment_content().dispose()));
        this.editionsMap.clear();
    }

    public Set<String> getFilenames(DocumentReference documentReference) {
        if (this.editionsMap.containsKey(documentReference)) {
            return this.editionsMap.get(documentReference).keySet();
        }
        return Collections.emptySet();
    }

    public Optional<XWikiAttachment> getAttachment(DocumentReference documentReference, String filename) {
        Map<String, XWikiAttachment> attachmentMap;
        Optional<XWikiAttachment> result = Optional.empty();
        if (this.editionsMap.containsKey(documentReference) && (attachmentMap = this.editionsMap.get(documentReference)).containsKey(filename)) {
            result = Optional.of(attachmentMap.get(filename));
        }
        return result;
    }

    public Collection<XWikiAttachment> getAttachments(DocumentReference documentReference) {
        Set<XWikiAttachment> result = Collections.emptySet();
        if (this.editionsMap.containsKey(documentReference)) {
            result = new HashSet<XWikiAttachment>(this.editionsMap.get(documentReference).values());
        }
        return result;
    }

    public boolean removeAttachment(DocumentReference documentReference, String filename) {
        Map<String, XWikiAttachment> attachmentMap;
        boolean result = false;
        if (this.editionsMap.containsKey(documentReference) && (attachmentMap = this.editionsMap.get(documentReference)).containsKey(filename)) {
            XWikiAttachment attachment = attachmentMap.remove(filename);
            attachment.getAttachment_content().dispose();
            result = true;
        }
        return result;
    }

    public boolean removeAttachments(DocumentReference documentReference) {
        Map<String, XWikiAttachment> attachmentMap;
        boolean result = false;
        if (this.editionsMap.containsKey(documentReference) && !(attachmentMap = this.editionsMap.get(documentReference)).isEmpty()) {
            result = true;
            ArrayList<XWikiAttachment> attachments = new ArrayList<XWikiAttachment>(attachmentMap.values());
            attachmentMap.clear();
            attachments.forEach(attachment -> attachment.getAttachment_content().dispose());
        }
        return result;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporaryAttachmentSession that = (TemporaryAttachmentSession)o;
        return new EqualsBuilder().append((Object)this.sessionId, (Object)that.sessionId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 63).append((Object)this.sessionId).toHashCode();
    }

    protected Map<DocumentReference, Map<String, XWikiAttachment>> getEditionsMap() {
        return this.editionsMap;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        this.dispose();
    }
}

