/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

public final class StoreFileUtils {
    private static final String FILE_VERSION_PREFIX = "v";
    private static final String FILE_NAME = "f";

    private StoreFileUtils() {
    }

    public static String getStoredFilename(String filename, String versionName) {
        int extensionIndex;
        StringBuilder storedFileNameBuilder = new StringBuilder(FILE_NAME);
        if (versionName != null) {
            storedFileNameBuilder.append(FILE_VERSION_PREFIX);
            storedFileNameBuilder.append(versionName);
        }
        if ((extensionIndex = filename.lastIndexOf(46)) != -1) {
            storedFileNameBuilder.append(filename.substring(extensionIndex));
        }
        return storedFileNameBuilder.toString();
    }

    public static File resolve(File targetFile, boolean followLinks) throws IOException {
        File linkFile;
        File file = targetFile;
        while (!file.exists() && (linkFile = StoreFileUtils.getLinkFile(file)).exists()) {
            if (followLinks) {
                file = new File(linkFile.getParent(), FileUtils.readFileToString((File)linkFile, (Charset)StandardCharsets.UTF_8));
                continue;
            }
            file = linkFile;
        }
        return file;
    }

    public static File getLinkFile(File originalfile) {
        return new File(originalfile.getParent(), originalfile.getName() + ".lnk");
    }

    public static String getLinkContent(File folder, File targetFile) {
        return folder.toPath().relativize(targetFile.toPath()).toString();
    }
}

