/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.filesystem.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.attachment.AttachmentAccessWrapper;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidator;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Session;
import org.xwiki.container.servlet.ServletSession;
import org.xwiki.internal.attachment.XWikiAttachmentAccessWrapper;
import org.xwiki.jakartabridge.servlet.JakartaServletBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.store.TemporaryAttachmentException;
import org.xwiki.store.TemporaryAttachmentSessionsManager;
import org.xwiki.store.filesystem.internal.TemporaryAttachmentSession;

@Component
@Singleton
public class DefaultTemporaryAttachmentSessionsManager
implements TemporaryAttachmentSessionsManager {
    private static final String ATTRIBUTE_KEY = "xwikiTemporaryAttachments";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Provider<AttachmentValidator> attachmentValidator;
    @Inject
    private Provider<Container> container;
    @Inject
    private Logger logger;

    private HttpSession getHttpSession() {
        Session session = ((Container)this.container.get()).getSession();
        return session != null ? ((ServletSession)session).getSession() : null;
    }

    private Optional<TemporaryAttachmentSession> getOrCreateSession() {
        Optional<TemporaryAttachmentSession> result = Optional.empty();
        HttpSession session = this.getHttpSession();
        if (session != null) {
            TemporaryAttachmentSession temporaryAttachmentSession = (TemporaryAttachmentSession)session.getAttribute(ATTRIBUTE_KEY);
            if (temporaryAttachmentSession == null) {
                temporaryAttachmentSession = new TemporaryAttachmentSession(session.getId());
                session.setAttribute(ATTRIBUTE_KEY, (Object)temporaryAttachmentSession);
            }
            result = Optional.of(temporaryAttachmentSession);
        }
        return result;
    }

    public XWikiAttachment uploadAttachment(DocumentReference documentReference, Part part) throws TemporaryAttachmentException, AttachmentValidationException {
        return this.uploadAttachment(documentReference, part, null);
    }

    @Deprecated
    public XWikiAttachment uploadAttachment(DocumentReference documentReference, javax.servlet.http.Part part, String filename) throws TemporaryAttachmentException, AttachmentValidationException {
        return this.uploadAttachment(documentReference, JakartaServletBridge.toJakarta((javax.servlet.http.Part)part), filename);
    }

    public XWikiAttachment uploadAttachment(DocumentReference documentReference, Part part, String filename) throws TemporaryAttachmentException, AttachmentValidationException {
        Optional<TemporaryAttachmentSession> optionalSession = this.getOrCreateSession();
        if (optionalSession.isEmpty()) {
            throw new TemporaryAttachmentException("Cannot find a user http session.");
        }
        TemporaryAttachmentSession temporaryAttachmentSession = optionalSession.get();
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiAttachment xWikiAttachment = new XWikiAttachment();
            String actualFilename = StringUtils.isNotBlank((CharSequence)filename) ? filename : part.getSubmittedFileName();
            xWikiAttachment.setFilename(actualFilename);
            xWikiAttachment.setContent(part.getInputStream());
            xWikiAttachment.setAuthorReference(context.getUserReference());
            xWikiAttachment.setDoc(new XWikiDocument(documentReference, documentReference.getLocale()), false);
            ((AttachmentValidator)this.attachmentValidator.get()).validateAttachment((AttachmentAccessWrapper)new XWikiAttachmentAccessWrapper(xWikiAttachment, context));
            temporaryAttachmentSession.addAttachment(documentReference, xWikiAttachment);
            return xWikiAttachment;
        }
        catch (IOException e) {
            throw new TemporaryAttachmentException("Error while reading the content of a request part", (Throwable)e);
        }
    }

    public void temporarilyAttach(XWikiAttachment attachment, DocumentReference documentReference) {
        Optional<TemporaryAttachmentSession> optionalSession = this.getOrCreateSession();
        if (optionalSession.isPresent()) {
            TemporaryAttachmentSession temporaryAttachmentSession = optionalSession.get();
            temporaryAttachmentSession.addAttachment(documentReference, attachment);
        } else {
            this.logger.error("Cannot find a user http session to attach [{}] to [{}].", (Object)attachment, (Object)documentReference);
        }
    }

    public Collection<XWikiAttachment> getUploadedAttachments(DocumentReference documentReference) {
        Optional<TemporaryAttachmentSession> optionalSession = this.getOrCreateSession();
        if (optionalSession.isEmpty()) {
            return Collections.emptyList();
        }
        TemporaryAttachmentSession temporaryAttachmentSession = optionalSession.get();
        return temporaryAttachmentSession.getAttachments(documentReference);
    }

    public Optional<XWikiAttachment> getUploadedAttachment(DocumentReference documentReference, String filename) {
        Optional<TemporaryAttachmentSession> optionalSession = this.getOrCreateSession();
        if (optionalSession.isPresent()) {
            TemporaryAttachmentSession temporaryAttachmentSession = optionalSession.get();
            return temporaryAttachmentSession.getAttachment(documentReference, filename);
        }
        return Optional.empty();
    }

    public boolean removeUploadedAttachment(DocumentReference documentReference, String filename) {
        Optional<TemporaryAttachmentSession> optionalSession = this.getOrCreateSession();
        if (optionalSession.isPresent()) {
            TemporaryAttachmentSession temporaryAttachmentSession = optionalSession.get();
            return temporaryAttachmentSession.removeAttachment(documentReference, filename);
        }
        this.logger.warn("Cannot find a user http session to remove attachment [{}] from [{}].", (Object)filename, (Object)documentReference);
        return false;
    }

    public boolean removeUploadedAttachments(DocumentReference documentReference) {
        Optional<TemporaryAttachmentSession> optionalSession = this.getOrCreateSession();
        if (optionalSession.isPresent()) {
            TemporaryAttachmentSession temporaryAttachmentSession = optionalSession.get();
            return temporaryAttachmentSession.removeAttachments(documentReference);
        }
        this.logger.warn("Cannot find a user http session to remove attachments from [{}].", (Object)documentReference);
        return false;
    }

    public void attachTemporaryAttachmentsInDocument(XWikiDocument document, List<String> fileNames) {
        if (!fileNames.isEmpty()) {
            for (String temporaryUploadedFile : fileNames) {
                Optional<XWikiAttachment> uploadedAttachmentOpt = this.getUploadedAttachment(document.getDocumentReference(), temporaryUploadedFile);
                uploadedAttachmentOpt.ifPresent(uploadedAttachment -> {
                    XWikiAttachment previousAttachment = document.setAttachment(uploadedAttachment);
                    if (previousAttachment != null) {
                        uploadedAttachment.setVersion(previousAttachment.getNextVersion());
                    }
                });
            }
        }
    }
}

