/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import org.xwiki.store.StartableTransactionRunnable;
import org.xwiki.store.TransactionRunnable;

public class FileDeleteTransactionRunnable
extends StartableTransactionRunnable<TransactionRunnable> {
    private final File toDelete;
    private final File backupFile;
    private final ReadWriteLock lock;
    private boolean preRunComplete;

    public FileDeleteTransactionRunnable(File toDelete, File backupFile, ReadWriteLock lock) {
        this.toDelete = toDelete;
        this.backupFile = backupFile;
        this.lock = lock;
    }

    protected void onPreRun() throws IOException {
        this.lock.writeLock().lock();
        this.clearBackup();
        this.preRunComplete = true;
    }

    protected void onRun() throws IOException {
        if (this.toDelete.exists()) {
            this.toDelete.renameTo(this.backupFile);
        }
    }

    protected void onRollback() {
        if (this.preRunComplete) {
            boolean isBackupFile = this.backupFile.exists();
            boolean isMainFile = this.toDelete.exists();
            if (isBackupFile && !isMainFile) {
                this.backupFile.renameTo(this.toDelete);
                return;
            }
            if (!isBackupFile && isMainFile) {
                return;
            }
            if (!isBackupFile && !isMainFile) {
                return;
            }
            if (isBackupFile && isMainFile) {
                throw new IllegalStateException("Tried to rollback the deletion of file " + this.toDelete.getAbsolutePath() + " and encountered a backup and a main file. Since the main file is renamed to a backup location before deleting, this should never happen.");
            }
        }
    }

    protected void onComplete() throws IOException {
        if (!this.preRunComplete) {
            throw new IllegalStateException("Deleting file: " + this.toDelete.getAbsolutePath() + " onPreRun has not been called, maybe the class was extended and it was overridden?");
        }
        try {
            this.clearBackup();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void clearBackup() throws IOException {
        if (this.backupFile.exists()) {
            this.backupFile.delete();
        }
        if (this.backupFile.exists()) {
            throw new IOException("Could not remove backup file, cannot proceed.");
        }
    }
}

