/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.web.sx;

import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.sx.Extension;
import com.xpn.xwiki.web.sx.SxCompressor;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.skinx.SkinExtensionConfiguration;

public class JsExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsExtension.class);

    @Override
    public String getClassName() {
        return "XWiki.JavaScriptExtension";
    }

    @Override
    public String getContentType() {
        return "text/javascript; charset=UTF-8";
    }

    @Override
    public SxCompressor getCompressor() {
        return new JsCompressor();
    }

    public static class JsCompressor
    implements SxCompressor {
        private String sourceMap;

        @Override
        public String compress(String source) {
            Compiler compiler = new Compiler();
            CompilerOptions options = new CompilerOptions();
            options.setLanguageIn(CompilerOptions.LanguageMode.STABLE);
            options.setLanguageOut(CompilerOptions.LanguageMode.NO_TRANSPILE);
            options.setRewritePolyfills(false);
            options.setStrictModeInput(this.getConfig().shouldRunJavaScriptInStrictMode());
            options.setEmitUseStrict(options.expectStrictModeInput());
            options.setSourceMapOutputPath(this.getSourceFileName() + ".map");
            CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
            SourceFile input = SourceFile.fromCode((String)this.getSourceFileName(), (String)source);
            Result result = compiler.compile(Collections.emptyList(), Collections.singletonList(input), options);
            compiler.getWarnings().forEach(warning -> LOGGER.warn("Warning at line [{}], column [{}]: [{}]", new Object[]{warning.getLineNumber(), warning.getCharno(), warning.getDescription()}));
            compiler.getErrors().forEach(error -> LOGGER.error("Error at line [{}], column [{}]: [{}]", new Object[]{error.getLineNumber(), error.getCharno(), error.getDescription()}));
            if (result.success) {
                try {
                    String compressed = compiler.toSource();
                    this.sourceMap = this.getSourceMap(compiler);
                    return compressed;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to compress JavaScript extension. Root cause is: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            return source;
        }

        private String getSourceFileName() {
            Provider xcontextProvider = (Provider)Utils.getComponent((Type)XWikiContext.TYPE_PROVIDER);
            return ((XWikiContext)xcontextProvider.get()).getDoc().getDocumentReference().toString();
        }

        private String getSourceMap(Compiler compiler) throws IOException {
            if (compiler.getSourceMap() != null) {
                StringBuilder sourceMapping = new StringBuilder();
                compiler.getSourceMap().appendTo((Appendable)sourceMapping, this.getSourceFileName());
                return sourceMapping.toString();
            }
            return null;
        }

        public String getSourceMap() {
            return this.sourceMap;
        }

        private SkinExtensionConfiguration getConfig() {
            return (SkinExtensionConfiguration)Utils.getComponent(SkinExtensionConfiguration.class);
        }
    }
}

