/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.internal.cache.rendering.CachedItem;
import com.xpn.xwiki.internal.cache.rendering.RenderingCacheAware;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.skinx.SkinExtensionPluginApi;
import com.xpn.xwiki.web.Utils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.skinx.internal.async.SkinExtensionAsync;

public abstract class AbstractSkinExtensionPlugin
extends XWikiDefaultPlugin
implements RenderingCacheAware {
    public static final String DEFER_DEFAULT_PARAM = "xwiki.plugins.skinx.deferred.default";
    protected static final String QUERY_PARAMETER_DELIMITER = "?";
    static final String PARAMETER_SEPARATOR = "&";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSkinExtensionPlugin.class);
    private static final String FORCE_SKIN_ACTION = "forceSkinAction";
    protected final String contextKey = ((Object)((Object)this)).getClass().getCanonicalName();
    protected final String parametersContextKey = ((Object)((Object)this)).getClass().getCanonicalName() + "_parameters";
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    private SkinExtensionAsync async;

    public AbstractSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public abstract String getLink(String var1, XWikiContext var2);

    public String getLink(String resource, Map<String, Object> parameters, XWikiContext context) {
        this.getParametersMap(context).put(resource, parameters);
        return this.getLink(resource, context);
    }

    public abstract Set<String> getAlwaysUsedExtensions(XWikiContext var1);

    public abstract boolean hasPageExtensions(XWikiContext var1);

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new SkinExtensionPluginApi((AbstractSkinExtensionPlugin)plugin, context);
    }

    String getSkinFileURL(String filename, XWikiContext context) {
        String parameters;
        boolean forceSkinAction = BooleanUtils.toBoolean((Boolean)((Boolean)this.getParameter(FORCE_SKIN_ACTION, filename, context)));
        StringBuilder url = new StringBuilder(context.getWiki().getSkinFile(filename, forceSkinAction, context));
        if (forceSkinAction && !StringUtils.isEmpty((CharSequence)(parameters = Strings.CS.removeStart(this.parametersAsQueryString(filename, context), (CharSequence)PARAMETER_SEPARATOR)))) {
            String queryParamDelimiter = StringUtils.contains((CharSequence)url, (CharSequence)QUERY_PARAMETER_DELIMITER) ? PARAMETER_SEPARATOR : QUERY_PARAMETER_DELIMITER;
            url.append(queryParamDelimiter).append(parameters);
        }
        return url.toString();
    }

    private void useResource(String resource, XWikiContext context) {
        LOGGER.debug("Using [{}] as [{}] extension", (Object)resource, (Object)this.getName());
        this.getPulledResources(context).add(resource);
    }

    public void use(String resource, XWikiContext context) {
        this.use(resource, null, context);
    }

    public void use(String resource, Map<String, Object> parameters, XWikiContext context) {
        this.useResource(resource, context);
        if (parameters == null) {
            this.getParametersMap(context).remove(resource);
        } else {
            this.getParametersMap(context).put(resource, parameters);
        }
        this.getSkinExtensionAsync().use(this.getName(), resource, parameters);
    }

    protected Set<String> getPulledResources(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Set)context.get((Object)this.contextKey);
    }

    protected Map<String, Map<String, Object>> getParametersMap(XWikiContext context) {
        this.initializeRequestListIfNeeded(context);
        return (Map)context.get((Object)this.parametersContextKey);
    }

    protected void initializeRequestListIfNeeded(XWikiContext context) {
        if (!context.containsKey((Object)this.contextKey)) {
            context.put((Object)this.contextKey, new LinkedHashSet());
        }
        if (!context.containsKey((Object)this.parametersContextKey)) {
            context.put((Object)this.parametersContextKey, new HashMap());
        }
    }

    public String getImportString(XWikiContext context) {
        StringBuilder result = new StringBuilder();
        LinkedHashSet<String> extensions = new LinkedHashSet<String>();
        extensions.addAll(this.getAlwaysUsedExtensions(context));
        extensions.addAll(this.getPulledResources(context));
        if (this.hasPageExtensions(context)) {
            EntityReferenceSerializer<String> serializer = this.getDefaultEntityReferenceSerializer();
            String serializedCurrentDocumentName = (String)serializer.serialize((EntityReference)context.getDoc().getDocumentReference(), new Object[0]);
            extensions.add(serializedCurrentDocumentName);
        }
        for (String documentName : extensions) {
            result.append(this.getLink(documentName, context));
        }
        return result.toString();
    }

    protected Map<String, Object> getParametersForResource(String resource, XWikiContext context) {
        Map<String, Object> result = this.getParametersMap(context).get(resource);
        if (result == null) {
            result = Collections.emptyMap();
        }
        return result;
    }

    protected Object getParameter(String parameterName, String resource, XWikiContext context) {
        return this.getParametersForResource(resource, context).get(parameterName);
    }

    protected String parametersAsQueryString(String resource, XWikiContext context) {
        Map<String, Object> parameters = this.getParametersForResource(resource, context);
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if (FORCE_SKIN_ACTION.equals(parameter.getKey())) continue;
            query.append(PARAMETER_SEPARATOR);
            query.append(this.sanitize(parameter.getKey()));
            query.append("=");
            query.append(this.sanitize(Objects.toString(parameter.getValue(), "")));
        }
        if ("false".equals(context.getRequest().getParameter("minify"))) {
            query.append("&minify=false");
        }
        return query.toString();
    }

    protected String sanitize(String value) {
        String result = value;
        try {
            result = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return result;
    }

    public String endParsing(String content, XWikiContext context) {
        String hook = "<!-- " + ((Object)((Object)this)).getClass().getCanonicalName() + " -->";
        String result = content.replaceFirst(hook, this.getImportString(context));
        return result;
    }

    public CachedItem.UsedExtension getCacheResources(XWikiContext context) {
        return new CachedItem.UsedExtension(this.getPulledResources(context), new HashMap<String, Map<String, Object>>(this.getParametersMap(context)));
    }

    public void restoreCacheResources(XWikiContext context, CachedItem.UsedExtension extension) {
        this.getPulledResources(context).addAll(extension.resources);
        this.getParametersMap(context).putAll(extension.parameters);
    }

    protected EntityReferenceSerializer<String> getDefaultEntityReferenceSerializer() {
        if (this.defaultEntityReferenceSerializer == null) {
            this.defaultEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING);
        }
        return this.defaultEntityReferenceSerializer;
    }

    protected DocumentReferenceResolver<String> getCurrentDocumentReferenceResolver() {
        if (this.currentDocumentReferenceResolver == null) {
            this.currentDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING, (String)"current");
        }
        return this.currentDocumentReferenceResolver;
    }

    protected SkinExtensionAsync getSkinExtensionAsync() {
        if (this.async == null) {
            this.async = (SkinExtensionAsync)Utils.getComponent(SkinExtensionAsync.class);
        }
        return this.async;
    }

    boolean isDefer(String name, XWikiContext context) {
        String defaultDeferString = context.getWiki().Param(DEFER_DEFAULT_PARAM);
        boolean defaultDefer = StringUtils.isEmpty((CharSequence)defaultDeferString) || Boolean.parseBoolean(defaultDeferString);
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.getParameter("defer", name, context)), (boolean)defaultDefer);
    }
}

