/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.skinx;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.skinx.AbstractSkinExtensionPlugin;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractDocumentSkinExtensionPlugin
extends AbstractSkinExtensionPlugin
implements EventListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDocumentSkinExtensionPlugin.class);
    private static final String USE_FIELDNAME = "use";
    private Map<String, Set<DocumentReference>> alwaysUsedExtensions;
    private final List<Event> events = new ArrayList<Event>(3);
    private DocumentAuthorizationManager authorizationManager;
    private DocumentReferenceResolver<String> stringDocumentReferenceResolver;
    private EntityReferenceResolver<String> currentEntityReferenceResolver;

    public AbstractDocumentSkinExtensionPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
        this.events.add((Event)new DocumentCreatedEvent());
        this.events.add((Event)new DocumentDeletedEvent());
        this.events.add((Event)new DocumentUpdatedEvent());
        this.events.add((Event)new WikiDeletedEvent());
    }

    public List<Event> getEvents() {
        return this.events;
    }

    protected abstract String getExtensionClassName();

    protected abstract String getExtensionName();

    public void init(XWikiContext context) {
        super.init(context);
        this.alwaysUsedExtensions = new HashMap<String, Set<DocumentReference>>();
        this.getExtensionClass(context);
        ((ObservationManager)Utils.getComponent(ObservationManager.class)).addListener((EventListener)this);
    }

    public void virtualInit(XWikiContext context) {
        super.virtualInit(context);
        this.getExtensionClass(context);
    }

    @Override
    public Set<String> getAlwaysUsedExtensions(XWikiContext context) {
        EntityReferenceSerializer<String> serializer = this.getDefaultEntityReferenceSerializer();
        Set<DocumentReference> references = this.getAlwaysUsedExtensions();
        HashSet<String> names = new HashSet<String>(references.size());
        for (DocumentReference reference : references) {
            names.add((String)serializer.serialize((EntityReference)reference, new Object[0]));
        }
        return names;
    }

    public Set<DocumentReference> getAlwaysUsedExtensions() {
        XWikiContext context = Utils.getContext();
        String currentWiki = (String)StringUtils.defaultIfEmpty((CharSequence)context.getWikiId(), (CharSequence)context.getMainXWiki());
        if (this.alwaysUsedExtensions.get(currentWiki) != null) {
            return this.alwaysUsedExtensions.get(currentWiki);
        }
        HashSet<DocumentReference> extensions = new HashSet<DocumentReference>();
        String query = ", BaseObject as obj, StringProperty as use where obj.className='" + this.getExtensionClassName() + "' and obj.name=doc.fullName and use.id.id=obj.id and use.id.name='use' and use.value='always'";
        try {
            for (DocumentReference extension : context.getWiki().getStore().searchDocumentReferences(query, context)) {
                try {
                    XWikiDocument doc = context.getWiki().getDocument(extension, context);
                    if (!this.getAuthorizationManager().hasAccess(Right.PROGRAM, null, doc.getAuthorReference(), doc.getDocumentReference())) continue;
                    extensions.add(extension);
                }
                catch (XWikiException e1) {
                    LOGGER.error("Error while adding skin extension [{}] as always used. It will be ignored.", (Object)extension, (Object)e1);
                }
            }
            this.alwaysUsedExtensions.put(currentWiki, extensions);
            return extensions;
        }
        catch (XWikiException e) {
            LOGGER.error("Error while retrieving always used JS extensions", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Override
    public boolean hasPageExtensions(XWikiContext context) {
        XWikiDocument doc = context.getDoc();
        boolean result = false;
        if (doc != null && this.hasCurrentPageExtensionObjects(doc)) {
            if (this.getAuthorizationManager().hasAccess(Right.SCRIPT, EntityType.DOCUMENT, doc.getAuthorReference(), doc.getDocumentReference())) {
                result = true;
            } else {
                this.displayScriptRightLog(doc.getDocumentReference());
            }
        }
        return result;
    }

    private void displayScriptRightLog(Object documentReference) {
        LOGGER.warn("Extensions present in [{}] ignored because of lack of script right from the author.", documentReference);
    }

    private boolean hasCurrentPageExtensionObjects(XWikiDocument doc) {
        Vector objects = doc.getObjects(this.getExtensionClassName());
        if (objects != null) {
            for (BaseObject obj : objects) {
                if (obj == null || !Strings.CS.equals(obj.getStringValue(USE_FIELDNAME), "currentPage")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void use(String resource, Map<String, Object> parameters, XWikiContext context) {
        String canonicalResource = this.getCanonicalDocumentName(resource);
        if (this.canResourceBeUsed(canonicalResource, context)) {
            super.use(canonicalResource, parameters, context);
        } else {
            this.displayScriptRightLog(canonicalResource);
        }
    }

    private DocumentReferenceResolver<String> getDocumentReferenceResolver() {
        if (this.stringDocumentReferenceResolver == null) {
            this.stringDocumentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING);
        }
        return this.stringDocumentReferenceResolver;
    }

    private DocumentAuthorizationManager getAuthorizationManager() {
        if (this.authorizationManager == null) {
            this.authorizationManager = (DocumentAuthorizationManager)Utils.getComponent(DocumentAuthorizationManager.class);
        }
        return this.authorizationManager;
    }

    private boolean canResourceBeUsed(String resource, XWikiContext context) {
        DocumentReferenceResolver<String> documentReferenceResolver = this.getDocumentReferenceResolver();
        DocumentReference documentReference = documentReferenceResolver.resolve((Object)resource, new Object[0]);
        try {
            XWikiDocument document = context.getWiki().getDocument(documentReference, context);
            DocumentReference authorReference = document.getAuthorReference();
            return this.getAuthorizationManager().hasAccess(Right.SCRIPT, EntityType.DOCUMENT, authorReference, documentReference);
        }
        catch (XWikiException e) {
            LOGGER.error("Error while loading [{}] for checking script right: [{}]", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug("Original error stack trace: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public String endParsing(String content, XWikiContext context) {
        return super.endParsing(content, context);
    }

    public BaseClass getExtensionClass(XWikiContext context) {
        try {
            XWikiDocument doc = context.getWiki().getDocument(this.getExtensionClassName(), context);
            return doc.getXClass();
        }
        catch (Exception ex) {
            LOGGER.error("Cannot get skin extension class [{}]", (Object)this.getExtensionClassName(), (Object)ex);
            return null;
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.alwaysUsedExtensions.remove(((WikiDeletedEvent)event).getWikiId());
        } else {
            this.onDocumentEvent((XWikiDocument)source);
        }
    }

    private void onDocumentEvent(XWikiDocument document) {
        boolean remove = false;
        if (document.getObject(this.getExtensionClassName()) != null) {
            if (document.getObject(this.getExtensionClassName(), USE_FIELDNAME, "always", false) != null) {
                if (this.getAuthorizationManager().hasAccess(Right.PROGRAM, null, document.getAuthorReference(), document.getDocumentReference())) {
                    this.getAlwaysUsedExtensions().add(document.getDocumentReference());
                    return;
                }
                remove = true;
            } else {
                remove = true;
            }
        } else if (document.getOriginalDocument().getObject(this.getExtensionClassName()) != null) {
            remove = true;
        }
        if (remove) {
            this.getAlwaysUsedExtensions().remove(document.getDocumentReference());
        }
    }

    private EntityReferenceResolver<String> getCurrentEntityReferenceResolver() {
        if (this.currentEntityReferenceResolver == null) {
            this.currentEntityReferenceResolver = (EntityReferenceResolver)Utils.getComponent((Type)EntityReferenceResolver.TYPE_STRING, (String)"current");
        }
        return this.currentEntityReferenceResolver;
    }

    private String getCanonicalDocumentName(String documentName) {
        EntityReferenceResolver<String> resolver = this.getCurrentEntityReferenceResolver();
        EntityReferenceSerializer<String> serializer = this.getDefaultEntityReferenceSerializer();
        return (String)serializer.serialize(resolver.resolve((Object)documentName, EntityType.DOCUMENT, new Object[0]), new Object[0]);
    }

    protected boolean isAccessible(String documentName, XWikiContext context) {
        return this.isAccessible(this.getCurrentDocumentReferenceResolver().resolve((Object)documentName, new Object[0]), context);
    }

    protected boolean isAccessible(DocumentReference documentReference, XWikiContext context) {
        if (!((ContextualAuthorizationManager)Utils.getComponent(ContextualAuthorizationManager.class)).hasAccess(Right.VIEW, (EntityReference)documentReference)) {
            LOGGER.debug("[{}] The current user [{}] does not have 'view' rights on the Skin Extension document [{}]", new Object[]{this.getName(), context.getUserReference(), documentReference});
            return false;
        }
        return true;
    }

    private String getDocumentVersion(DocumentReference documentReference, XWikiContext context) {
        try {
            return context.getWiki().getDocument(documentReference, context).getVersion();
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to load document [{}].", (Object)documentReference, (Object)e);
            return "";
        }
    }

    private String getDocumentVersionQueryString(DocumentReference documentReference, XWikiContext context) {
        return "docVersion=" + this.sanitize(this.getDocumentVersion(documentReference, context));
    }

    private String getLanguageQueryString(XWikiContext context) {
        Locale locale = context.getLocale();
        if (locale != null) {
            return "language=" + this.sanitize(locale.toString());
        }
        return "";
    }

    protected String getDocumentSkinExtensionURL(DocumentReference documentReference, String documentName, String pluginName, XWikiContext context) {
        String queryString = String.format("%s&%s%s", this.getLanguageQueryString(context), this.getDocumentVersionQueryString(documentReference, context), this.parametersAsQueryString(documentName, context));
        return context.getWiki().getURL(documentReference, pluginName, queryString, "", context);
    }
}

