/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.sheet.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.sheet.SheetBinder;
import org.xwiki.sheet.SheetManager;
import org.xwiki.sheet.internal.ModelBridge;

@Component
@Singleton
public class DefaultSheetManager
implements SheetManager {
    private static final String SHEET_CLASS = "XWiki.SheetDescriptorClass";
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    @Named(value="document")
    private SheetBinder documentSheetBinder;
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    private String getContextSheet() {
        return (String)this.execution.getContext().getProperty("sheet");
    }

    @Override
    public List<DocumentReference> getSheets(DocumentModelBridge document, String action) {
        DocumentReference sheetReference;
        DocumentReference documentReference = document.getDocumentReference();
        String sheetStringRef = this.getContextSheet();
        if (sheetStringRef != null && documentReference.equals((Object)this.documentAccessBridge.getCurrentDocumentReference()) && this.matchSheet(sheetReference = this.documentReferenceResolver.resolve((Object)sheetStringRef, new Object[]{documentReference}), action)) {
            return Collections.singletonList(sheetReference);
        }
        List<DocumentReference> sheets = this.getDocumentSheets(document, action);
        if (sheets.isEmpty()) {
            sheets = new ArrayList<DocumentReference>();
            for (DocumentReference classReference : this.modelBridge.getXObjectClassReferences(document)) {
                sheets.addAll(this.getClassSheets(classReference, action));
            }
        }
        return sheets;
    }

    private List<DocumentReference> getClassSheets(DocumentReference classReference, String action) {
        DocumentModelBridge classDocument;
        try {
            classDocument = this.documentAccessBridge.getTranslatedDocumentInstance(classReference);
        }
        catch (Exception e) {
            String classStringReference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)classReference, new Object[0]);
            this.logger.warn("Failed to get class sheets for [{}]. Reason: [{}]", (Object)classStringReference, (Object)e.getMessage());
            return Collections.emptyList();
        }
        ArrayList<DocumentReference> sheetReferences = new ArrayList<DocumentReference>();
        for (DocumentReference sheetReference : this.classSheetBinder.getSheets(classDocument)) {
            if (!this.matchSheet(sheetReference, action)) continue;
            sheetReferences.add(sheetReference);
        }
        return sheetReferences;
    }

    private List<DocumentReference> getDocumentSheets(DocumentModelBridge document, String action) {
        ArrayList<DocumentReference> sheets = new ArrayList<DocumentReference>();
        for (DocumentReference sheetReference : this.documentSheetBinder.getSheets(document)) {
            if (!this.matchSheet(sheetReference, action)) continue;
            sheets.add(sheetReference);
        }
        return sheets;
    }

    private boolean matchSheet(DocumentReference sheetReference, String expectedAction) {
        try {
            if (!this.documentAccessBridge.exists(sheetReference)) {
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to check for the existance of the sheet with reference [{}]", (Object)sheetReference, (Object)e);
            return false;
        }
        DocumentReference sheetClassReference = this.documentReferenceResolver.resolve((Object)SHEET_CLASS, new Object[]{sheetReference});
        String actualAction = (String)this.documentAccessBridge.getProperty(sheetReference, sheetClassReference, "action");
        return StringUtils.isEmpty((CharSequence)expectedAction) || StringUtils.isEmpty((CharSequence)actualAction) || actualAction.equals(expectedAction);
    }

    @Override
    public boolean isSheetForced() {
        return this.getContextSheet() != null;
    }
}

