/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.display;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.platform.security.requiredrights.internal.display.AbstractBlockSupplierProvider;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;

@Component
@Singleton
public class MacroDisplayerProvider
extends AbstractBlockSupplierProvider<MacroBlock> {
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private MacroManager macroManager;
    @Inject
    private RenderingContext renderingContext;
    @Inject
    private MacroContentParser macroContentParser;

    public Supplier<Block> get(MacroBlock macroBlock, Object ... parameters) {
        String macroId = macroBlock.getId();
        String translationKeyPrefix = "rendering.macro." + macroId;
        Map parameterDescriptors = Map.of();
        ContentDescriptor contentDescriptor = null;
        try {
            MacroId macroIdWithSyntax = new MacroId(macroId, this.macroContentParser.getCurrentSyntax(this.getTransformationContext(macroBlock)));
            MacroDescriptor macroDescriptor = this.macroManager.getMacro(macroIdWithSyntax).getDescriptor();
            parameterDescriptors = macroDescriptor.getParameterDescriptorMap();
            contentDescriptor = macroDescriptor.getContentDescriptor();
        }
        catch (MacroLookupException macroIdWithSyntax) {
            // empty catch block
        }
        ArrayList<AbstractBlockSupplierProvider.PropertyDisplay> properties = new ArrayList<AbstractBlockSupplierProvider.PropertyDisplay>();
        for (Map.Entry entry : macroBlock.getParameters().entrySet()) {
            String parameterName = (String)entry.getKey();
            String parameterValue = (String)entry.getValue();
            String parameterTranslationKey = translationKeyPrefix + ".parameter." + parameterName;
            ParameterDescriptor parameterDescriptor = (ParameterDescriptor)parameterDescriptors.get(parameterName);
            String displayName = this.getParameterDisplayName(parameterName, parameterTranslationKey, parameterDescriptor);
            String description = this.getParameterDescription(parameterTranslationKey, parameterDescriptor);
            properties.add(new AbstractBlockSupplierProvider.PropertyDisplay(displayName, description, parameterValue, false));
        }
        String contentLabel = this.maybeTranslate("rendering.macroContent", "Content");
        String fallbackContentDescription = contentDescriptor != null ? contentDescriptor.getDescription() : null;
        String contentDescriptionKey = translationKeyPrefix + ".content.description";
        String contentDescription = this.maybeTranslate(contentDescriptionKey, fallbackContentDescription);
        properties.add(new AbstractBlockSupplierProvider.PropertyDisplay(contentLabel, contentDescription, macroBlock.getContent(), false));
        return () -> this.renderProperties(properties);
    }

    private String getParameterDescription(String parameterTranslationKey, ParameterDescriptor parameterDescriptor) {
        String fallbackDescription = parameterDescriptor != null ? parameterDescriptor.getDescription() : null;
        return this.maybeTranslate(parameterTranslationKey + ".description", fallbackDescription);
    }

    private String getParameterDisplayName(String parameterName, String parameterTranslationKey, ParameterDescriptor parameterDescriptor) {
        String fallbackName = parameterDescriptor != null ? parameterDescriptor.getName() : parameterName;
        return this.maybeTranslate(parameterTranslationKey + ".name", fallbackName);
    }

    private String maybeTranslate(String key, String fallback) {
        String translation = this.localizationManager.getTranslationPlain(key, new Object[0]);
        if (translation != null) {
            return translation;
        }
        return fallback;
    }

    private MacroTransformationContext getTransformationContext(MacroBlock macroBlock) {
        MacroTransformationContext macroTransformationContext = new MacroTransformationContext();
        macroTransformationContext.setId("RequiredRightAnalyzer_" + macroBlock.getId());
        macroTransformationContext.setCurrentMacroBlock(macroBlock);
        macroTransformationContext.setSyntax(this.renderingContext.getDefaultSyntax());
        macroTransformationContext.setInline(macroBlock.isInline());
        return macroTransformationContext;
    }
}

