/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.bridge.internal.DocumentContextExecutor;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;

@Component
@Singleton
public class XWikiDocumentRequiredRightAnalyzer
implements RequiredRightAnalyzer<XWikiDocument> {
    @Inject
    private DocumentContextExecutor documentContextExecutor;
    @Inject
    private RequiredRightAnalyzer<BaseObject> objectRequiredRightAnalyzer;
    @Inject
    private RequiredRightAnalyzer<BaseClass> classRequiredRightAnalyzer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="content")
    private RequiredRightAnalyzer<XWikiDocument> contentRequiredRightAnalyzer;

    public List<RequiredRightAnalysisResult> analyze(XWikiDocument document) throws RequiredRightsException {
        try {
            ArrayList result = new ArrayList(this.contentRequiredRightAnalyzer.analyze((Object)document));
            return (List)this.documentContextExecutor.call(() -> {
                XWikiDocument rootLocaleDocument = document;
                if (document.getLocale() != null && !document.getLocale().equals(Locale.ROOT)) {
                    XWikiContext context = (XWikiContext)this.contextProvider.get();
                    rootLocaleDocument = context.getWiki().getDocument(document.getDocumentReference(), context);
                }
                result.addAll(this.classRequiredRightAnalyzer.analyze((Object)rootLocaleDocument.getXClass()));
                for (List baseObjects : rootLocaleDocument.getXObjects().values()) {
                    for (BaseObject object : baseObjects) {
                        result.addAll(this.objectRequiredRightAnalyzer.analyze((Object)object));
                    }
                }
                return result;
            }, (DocumentModelBridge)document);
        }
        catch (Exception e) {
            throw new RequiredRightsException("Error...", (Throwable)e);
        }
    }
}

