/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;

@Component
@Singleton
public class XDOMRequiredRightAnalyzer
implements RequiredRightAnalyzer<XDOM> {
    public static final String ENTITY_REFERENCE_METADATA = "entityReference";
    @Inject
    private Provider<RequiredRightAnalyzer<MacroBlock>> defaultMacroBlockRequiredRightAnalyzer;

    public List<RequiredRightAnalysisResult> analyze(XDOM dom) throws RequiredRightsException {
        List macroBlocks = dom.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        ArrayList<RequiredRightAnalysisResult> result = new ArrayList<RequiredRightAnalysisResult>();
        RequiredRightAnalyzer analyzer = (RequiredRightAnalyzer)this.defaultMacroBlockRequiredRightAnalyzer.get();
        for (MacroBlock macroBlock : macroBlocks) {
            result.addAll(analyzer.analyze((Object)macroBlock));
        }
        return result;
    }
}

