/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;

@Component(hints={"XWiki.JavaScriptExtension", "XWiki.StyleSheetExtension"})
@Singleton
public class SkinExtensionObjectRequiredRightAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    private BlockSupplierProvider<BaseObject> xObjectDisplayerProvider;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        String translationKey;
        RequiredRight requiredRight;
        String use = object.getStringValue("use");
        boolean isAlways = Objects.equals(use, "always");
        if (isAlways) {
            requiredRight = RequiredRight.PROGRAM;
            translationKey = "security.requiredrights.object.skinExtension.always";
        } else {
            requiredRight = RequiredRight.SCRIPT;
            translationKey = "security.requiredrights.object.skinExtension";
        }
        return List.of(new RequiredRightAnalysisResult(object.getReference(), this.translationMessageSupplierProvider.get((Object)translationKey, new Object[0]), this.xObjectDisplayerProvider.get((Object)object, new Object[0]), List.of(requiredRight)));
    }
}

