/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;

@Component
@Singleton
public class DefaultBaseClassRequiredRightAnalyzer
implements RequiredRightAnalyzer<BaseClass> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    private BlockSupplierProvider<BaseCollection<? extends EntityReference>> baseCollectionBlockSupplierProvider;

    public List<RequiredRightAnalysisResult> analyze(BaseClass xClass) throws RequiredRightsException {
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>();
        block2: for (Object field : xClass.getFieldList()) {
            if (!(field instanceof PropertyClass)) continue;
            PropertyClass propertyClass = (PropertyClass)field;
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            Class superClass = PropertyClass.class.getSuperclass();
            Class<?> clazz = propertyClass.getClass();
            while (!clazz.equals(superClass)) {
                DefaultParameterizedType roleType = new DefaultParameterizedType(null, RequiredRightAnalyzer.class, new Type[]{clazz});
                if (componentManager.hasComponent((Type)roleType)) {
                    try {
                        RequiredRightAnalyzer analyzer = (RequiredRightAnalyzer)componentManager.getInstance((Type)roleType);
                        results.addAll(analyzer.analyze((Object)propertyClass));
                    }
                    catch (Exception e) {
                        results.add(new RequiredRightAnalysisResult(propertyClass.getReference(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.class.errorAnalyzingProperty", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)}), this.baseCollectionBlockSupplierProvider.get((Object)propertyClass, new Object[0]), List.of(RequiredRight.MAYBE_PROGRAM)));
                    }
                    continue block2;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return results;
    }
}

