/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import com.xpn.xwiki.objects.classes.DBListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.display.BlockSupplierProvider;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.query.QueryException;
import org.xwiki.query.hql.internal.HQLStatementValidator;
import org.xwiki.velocity.internal.util.VelocityDetector;

@Component
@Singleton
public class DBListClassRequiredRightAnalyzer
implements RequiredRightAnalyzer<DBListClass> {
    @Inject
    private VelocityDetector velocityDetector;
    @Inject
    @Named(value="translation")
    private BlockSupplierProvider<String> translationMessageSupplierProvider;
    @Inject
    @Named(value="stringCode")
    private BlockSupplierProvider<String> stringCodeBlockSupplierProvider;
    @Inject
    private QueryBuilder<DBListClass> dbListClassQueryBuilder;
    @Inject
    private HibernateStore hibernate;
    @Inject
    private HQLStatementValidator hqlStatementValidator;
    @Inject
    private RequiredRightAnalyzer<PropertyClass> propertyClassRequiredRightAnalyzer;

    public List<RequiredRightAnalysisResult> analyze(DBListClass dbListClass) throws RequiredRightsException {
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>(this.propertyClassRequiredRightAnalyzer.analyze((Object)dbListClass));
        if (dbListClass != null && StringUtils.isNotBlank((CharSequence)dbListClass.getSql())) {
            String sql = dbListClass.getSql();
            if (this.velocityDetector.containsVelocityScript(sql)) {
                results.add(new RequiredRightAnalysisResult(dbListClass.getReference(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.class.dbListVelocity", new Object[0]), this.stringCodeBlockSupplierProvider.get((Object)sql, new Object[0]), RequiredRight.SCRIPT_AND_MAYBE_PROGRAM));
            } else {
                try {
                    Query query = this.dbListClassQueryBuilder.build((Object)dbListClass);
                    results.addAll(this.validateQuery(dbListClass, query));
                }
                catch (QueryException e) {
                    results.add(new RequiredRightAnalysisResult(dbListClass.getReference(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.class.errorParsingQuery", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e)}), this.stringCodeBlockSupplierProvider.get((Object)sql, new Object[0]), List.of(RequiredRight.MAYBE_PROGRAM)));
                }
            }
        }
        return results;
    }

    private List<RequiredRightAnalysisResult> validateQuery(DBListClass dbListClass, Query query) throws QueryException {
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>();
        if (query.isNamed()) {
            Optional<String> hqlQuery = this.getNamedQuery(query);
            if (hqlQuery.isEmpty() || !this.hqlStatementValidator.isSafe(hqlQuery.get())) {
                results.add(new RequiredRightAnalysisResult(dbListClass.getReference(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.class.unsafeNamedQuery", new Object[0]), this.stringCodeBlockSupplierProvider.get((Object)query.getStatement(), new Object[0]), List.of(RequiredRight.PROGRAM)));
            }
        } else if (!this.hqlStatementValidator.isSafe(query.getStatement())) {
            results.add(new RequiredRightAnalysisResult(dbListClass.getReference(), this.translationMessageSupplierProvider.get((Object)"security.requiredrights.class.unsafeQuery", new Object[0]), this.stringCodeBlockSupplierProvider.get((Object)query.getStatement(), new Object[0]), List.of(RequiredRight.PROGRAM)));
        }
        return results;
    }

    private Optional<String> getNamedQuery(Query query) {
        return Optional.ofNullable((NamedQueryDefinition)this.hibernate.getConfiguration().getNamedQueries().get(query.getStatement())).map(NamedQueryDefinition::getQuery);
    }
}

