/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal.analyzer;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.PropertyInterface;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.platform.security.requiredrights.internal.analyzer.ObjectPropertyRequiredRightAnalyzer;

@Component
@Singleton
@Named(value="XWiki.ConfigurableClass")
public class ConfigurableClassRequiredRightsAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    private ObjectPropertyRequiredRightAnalyzer objectPropertyRequiredRightAnalyzer;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        ArrayList<RequiredRightAnalysisResult> result = new ArrayList<RequiredRightAnalysisResult>(this.objectPropertyRequiredRightAnalyzer.analyzeAllProperties(object));
        String headingFieldName = "heading";
        String heading = object.getStringValue(headingFieldName);
        PropertyInterface field = object.getField(headingFieldName);
        if (StringUtils.isNotBlank((CharSequence)heading)) {
            result.addAll(this.objectPropertyRequiredRightAnalyzer.analyzeVelocityScriptValue(heading, field.getReference(), "security.requiredrights.object.configurableClassHeading"));
        }
        return result;
    }
}

