/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.security.authorization.Right;
import org.xwiki.text.XWikiToStringBuilder;

public class RequiredRightsChangedResult {
    private final Set<RequiredRightAnalysisResult> added = new LinkedHashSet<RequiredRightAnalysisResult>();
    private final Set<RequiredRightAnalysisResult> removed = new LinkedHashSet<RequiredRightAnalysisResult>();
    private final Map<Right, Boolean> addedRights = new HashMap<Right, Boolean>();
    private final Map<Right, Boolean> removedRights = new HashMap<Right, Boolean>();
    private boolean empty = true;

    public void add(RequiredRightAnalysisResult analysis, Right right, boolean added, boolean manualReviewNeeded) {
        this.empty = false;
        if (added) {
            this.add(this.added, analysis, this.addedRights, right, manualReviewNeeded);
        } else {
            this.add(this.removed, analysis, this.removedRights, right, manualReviewNeeded);
        }
        if ((right == Right.SCRIPT || right == Right.PROGRAM) && Objects.equals(this.removedRights.get(right), false) && Objects.equals(this.removedRights.get(Right.PROGRAM), true)) {
            this.removedRights.remove(Right.PROGRAM);
        }
    }

    private void add(Set<RequiredRightAnalysisResult> removed, RequiredRightAnalysisResult analysis, Map<Right, Boolean> rightsMap, Right right, boolean manualReviewNeeded) {
        removed.add(analysis);
        rightsMap.compute(right, (r, manualReviewValue) -> (manualReviewValue == null || manualReviewValue != false) && manualReviewNeeded);
    }

    public boolean hasAdded() {
        return !this.added.isEmpty();
    }

    public boolean hasRemoved() {
        return !this.removed.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Map<EntityReference, Set<RequiredRightAnalysisResult>> getAddedAsMap() {
        return RequiredRightsChangedResult.makeMap(this.added);
    }

    public Map<EntityReference, Set<RequiredRightAnalysisResult>> getRemovedAsMap() {
        return RequiredRightsChangedResult.makeMap(this.removed);
    }

    public Map<Right, Boolean> getAddedRights() {
        return this.addedRights;
    }

    public Map<Right, Boolean> getRemovedRights() {
        return this.removedRights;
    }

    public boolean hasRightWithManualReviewNeeded() {
        return this.removedRights.containsValue(true) || this.addedRights.containsValue(true);
    }

    public Set<RequiredRightAnalysisResult> getAdded() {
        return this.added;
    }

    public Set<RequiredRightAnalysisResult> getRemoved() {
        return this.removed;
    }

    private static Map<EntityReference, Set<RequiredRightAnalysisResult>> makeMap(Set<RequiredRightAnalysisResult> list) {
        HashMap<EntityReference, Set<RequiredRightAnalysisResult>> map = new HashMap<EntityReference, Set<RequiredRightAnalysisResult>>();
        for (RequiredRightAnalysisResult requiredRightAnalysisResult : list) {
            EntityReference entityReference = requiredRightAnalysisResult.getEntityReference();
            EntityReference extractedDocument = entityReference.extractReference(EntityType.DOCUMENT);
            if (extractedDocument instanceof DocumentReference && !extractedDocument.equals((Object)entityReference)) {
                entityReference = entityReference.replaceParent(extractedDocument, (EntityReference)RequiredRightsChangedResult.cleanupLocale((DocumentReference)extractedDocument));
            } else if (entityReference instanceof DocumentReference) {
                entityReference = RequiredRightsChangedResult.cleanupLocale((DocumentReference)entityReference);
            }
            if (map.containsKey(entityReference)) {
                ((Set)map.get(entityReference)).add(requiredRightAnalysisResult);
                continue;
            }
            map.put(entityReference, new LinkedHashSet<RequiredRightAnalysisResult>(Set.of(requiredRightAnalysisResult)));
        }
        return map;
    }

    private static DocumentReference cleanupLocale(DocumentReference entityReference) {
        DocumentReference documentReference = entityReference;
        if (documentReference.getLocale() == null || documentReference.getLocale().equals(Locale.ROOT)) {
            documentReference = documentReference.withoutLocale();
        }
        return documentReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredRightsChangedResult that = (RequiredRightsChangedResult)o;
        return new EqualsBuilder().append(this.empty, that.empty).append(this.added, that.added).append(this.removed, that.removed).append(this.addedRights, that.addedRights).append(this.removedRights, that.removedRights).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.added).append(this.removed).append(this.addedRights).append(this.removedRights).append(this.empty).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("empty", this.empty).append("added", this.added).append("removed", this.removed).append("addedRights", this.addedRights).append("removedRights", this.removedRights).toString();
    }
}

