/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.platform.security.requiredrights.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.document.DocumentAuthors;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRight;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.internal.RequiredRightsChangedResult;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReferenceSerializer;

@Component(roles={RequiredRightsChangedFilter.class})
@Singleton
public class RequiredRightsChangedFilter {
    private static final Set<EntityType> OBJECT_ENTITY_TYPES = Set.of(EntityType.OBJECT, EntityType.OBJECT_PROPERTY);
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceSerializer;

    public RequiredRightsChangedResult filter(DocumentAuthors authors, List<RequiredRightAnalysisResult> resultList) {
        RequiredRightsChangedResult requiredRightsChangedResult = new RequiredRightsChangedResult();
        if (resultList == null || resultList.isEmpty()) {
            return requiredRightsChangedResult;
        }
        DocumentReference userReference = ((XWikiContext)this.contextProvider.get()).getUserReference();
        DocumentReference contentAuthorReference = (DocumentReference)this.userReferenceSerializer.serialize(authors.getContentAuthor());
        DocumentReference effectiveMetadataAuthorReference = (DocumentReference)this.userReferenceSerializer.serialize(authors.getEffectiveMetadataAuthor());
        for (RequiredRightAnalysisResult analysis : resultList) {
            EntityReference analyzedEntityReference = analysis.getEntityReference();
            for (RequiredRight requiredRight : analysis.getRequiredRights()) {
                boolean authorHasAccess;
                boolean currentUserHasAccess;
                Right right = requiredRight.getRight();
                EntityType entityType = requiredRight.getEntityType();
                EntityReference documentEntityReference = analyzedEntityReference.extractReference(EntityType.DOCUMENT);
                DocumentReference documentReference = new DocumentReference(documentEntityReference);
                DocumentReference authorReference = OBJECT_ENTITY_TYPES.contains(analyzedEntityReference.getType()) ? effectiveMetadataAuthorReference : contentAuthorReference;
                if (Objects.equals(userReference, authorReference) || (currentUserHasAccess = this.authorizationManager.hasAccess(right, entityType, userReference, documentReference)) == (authorHasAccess = this.authorizationManager.hasAccess(right, entityType, authorReference, documentReference))) continue;
                requiredRightsChangedResult.add(analysis, right, currentUserHasAccess, requiredRight.isManualReviewNeeded());
            }
        }
        return requiredRightsChangedResult;
    }
}

