/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.internal;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.internal.XWikiBridge;

@Component
@Singleton
public class DefaultXWikiBridge
implements XWikiBridge {
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<EntityReference> currentResolver;
    @Inject
    private EntityReferenceFactory referenceFactory;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    private WikiReference mainWikiReference;

    public WikiReference getMainWikiReference() {
        if (this.mainWikiReference == null) {
            this.mainWikiReference = (WikiReference)this.referenceFactory.getReference((EntityReference)new WikiReference(((XWikiContext)this.xcontextProvider.get()).getMainXWiki()));
        }
        return this.mainWikiReference;
    }

    public boolean isWikiReadOnly() {
        return ((XWikiContext)this.xcontextProvider.get()).getWiki().isReadOnly();
    }

    public boolean needsAuthentication(Right right) {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        String prefName = "authenticate_" + right.getName();
        String value = context.getWiki().getXWikiPreference(prefName, "", context);
        Boolean result = this.checkNeedsAuthValue(value);
        if (result != null) {
            return result;
        }
        value = context.getWiki().getSpacePreference(prefName, "", context).toLowerCase();
        result = this.checkNeedsAuthValue(value);
        if (result != null) {
            return result;
        }
        return false;
    }

    private Boolean checkNeedsAuthValue(String value) {
        if (value != null && !value.equals("")) {
            if ("yes".equalsIgnoreCase(value)) {
                return true;
            }
            try {
                if (Integer.parseInt(value) > 0) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public EntityReference toCompatibleEntityReference(EntityReference reference) {
        if (reference == null) {
            return reference;
        }
        EntityReference compatibleReference = this.currentResolver.resolve((Object)reference.removeParameters(true), reference.getType(), new Object[0]);
        if (compatibleReference.getType() == EntityType.PAGE || compatibleReference.getType().isAllowedAncestor(EntityType.PAGE)) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            compatibleReference = xcontext.getWiki().getDocumentReference(reference, xcontext);
        }
        return compatibleReference;
    }
}

