/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xpn.xwiki.user.api.XWikiUser;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public class XWikiCachingRightService
implements XWikiRightService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XWikiCachingRightService.class);
    private static final String DELETE_ACTION = "delete";
    private static final String LOGIN_ACTION = "login";
    private static final ActionMap ACTION_MAP = new ActionMap();
    private DocumentReferenceResolver<String> documentReferenceResolver = (DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING, (String)"currentmixed");
    private DocumentReferenceResolver<String> userAndGroupReferenceResolver = (DocumentReferenceResolver)Utils.getComponent((Type)DocumentReferenceResolver.TYPE_STRING, (String)"user");
    private final RenderingContext renderingContext = (RenderingContext)Utils.getComponent(RenderingContext.class);
    private final AuthorizationManager authorizationManager = (AuthorizationManager)Utils.getComponent(AuthorizationManager.class);
    private final ContextualAuthorizationManager contextualAuthorizationManager = (ContextualAuthorizationManager)Utils.getComponent(ContextualAuthorizationManager.class);

    public static Right actionToRight(String action) {
        Right right = (Right)ACTION_MAP.get(action);
        if (right == null) {
            return Right.ILLEGAL;
        }
        return right;
    }

    private DocumentReference resolveUserName(String username, WikiReference wikiReference) {
        return this.userAndGroupReferenceResolver.resolve((Object)username, new Object[]{wikiReference});
    }

    private DocumentReference resolveDocumentName(String docname, WikiReference wikiReference) {
        return this.documentReferenceResolver.resolve((Object)docname, new Object[]{wikiReference});
    }

    private void showLogin(XWikiContext context) {
        try {
            if (context.getRequest() != null && !LOGIN_ACTION.equals(context.getAction()) && !context.getWiki().Param("xwiki.hidelogin", "false").equalsIgnoreCase("true")) {
                context.getWiki().getAuthService().showLogin(context);
            }
        }
        catch (XWikiException e) {
            LOGGER.error("Failed to show login page.", (Throwable)e);
        }
    }

    private void authenticateUser(XWikiContext context) {
        DocumentReference contextUserReference = context.getUserReference();
        DocumentReference userReference = contextUserReference;
        if (userReference == null && context.getMode() != 2) {
            try {
                XWikiUser user = context.getWiki().checkAuth(context);
                if (user != null) {
                    userReference = this.resolveUserName(user.getUser(), new WikiReference(context.getWikiId()));
                }
            }
            catch (XWikiException e) {
                LOGGER.error("Caught exception while authenticating user.", (Throwable)e);
            }
        }
        if (userReference != null && "XWikiGuest".equals(userReference.getName())) {
            userReference = null;
        }
        if (!(userReference == contextUserReference || userReference != null && userReference.equals((Object)contextUserReference))) {
            context.setUserReference(userReference);
        }
    }

    public boolean checkAccess(String action, XWikiDocument doc, XWikiContext context) throws XWikiException {
        Right right = XWikiCachingRightService.actionToRight(action);
        DocumentReference entityReference = doc.getDocumentReference();
        LOGGER.debug("checkAccess for action [{}] on entity [{}].", (Object)right, (Object)entityReference);
        this.authenticateUser(context);
        if (this.contextualAuthorizationManager.hasAccess(right, (EntityReference)entityReference)) {
            return true;
        }
        if (context.getUserReference() == null && !DELETE_ACTION.equals(action) && !LOGIN_ACTION.equals(action) && context.get((Object)"inactiveUserReference") == null) {
            LOGGER.debug("Redirecting unauthenticated user to login, since it have been denied [{}] on [{}].", (Object)right, (Object)entityReference);
            this.showLogin(context);
        }
        return false;
    }

    public boolean hasAccessLevel(String rightName, String username, String docname, XWikiContext context) throws XWikiException {
        WikiReference wikiReference = new WikiReference(context.getWikiId());
        DocumentReference document = this.resolveDocumentName(docname, wikiReference);
        LOGGER.debug("hasAccessLevel() resolved document named [{}] into reference [{}]", (Object)docname, (Object)document);
        DocumentReference user = this.resolveUserName(username, wikiReference);
        if (user != null && "XWikiGuest".equals(user.getName())) {
            user = null;
        }
        Right right = Right.toRight((String)rightName);
        return this.authorizationManager.hasAccess(right, user, (EntityReference)document);
    }

    public boolean hasProgrammingRights(XWikiContext context) {
        return this.contextualAuthorizationManager.hasAccess(Right.PROGRAM);
    }

    public boolean hasProgrammingRights(XWikiDocument doc, XWikiContext context) {
        WikiReference wiki;
        DocumentReference user;
        if (doc != null) {
            user = doc.getContentAuthorReference();
            wiki = doc.getDocumentReference().getWikiReference();
        } else {
            user = context.getUserReference();
            wiki = new WikiReference(context.getWikiId());
        }
        if (user != null && "XWikiGuest".equals(user.getName())) {
            user = null;
        }
        return this.authorizationManager.hasAccess(Right.PROGRAM, user, (EntityReference)wiki);
    }

    public boolean hasAdminRights(XWikiContext context) {
        return this.contextualAuthorizationManager.hasAccess(Right.ADMIN);
    }

    public boolean hasWikiAdminRights(XWikiContext context) {
        return this.contextualAuthorizationManager.hasAccess(Right.ADMIN, (EntityReference)new WikiReference(context.getWikiId()));
    }

    public List<String> listAllLevels(XWikiContext context) throws XWikiException {
        return Right.getAllRightsAsString();
    }

    static {
        ACTION_MAP.putAction(LOGIN_ACTION, Right.LOGIN).putAction("view", Right.VIEW).putAction(DELETE_ACTION, Right.DELETE).putAction("distribution", Right.VIEW).putAction("admin", Right.ADMIN).putAction("programming", Right.PROGRAM).putAction("edit", Right.EDIT).putAction("register", Right.REGISTER).putAction("logout", Right.LOGIN).putAction("loginerror", Right.LOGIN).putAction("loginsubmit", Right.LOGIN).putAction("viewrev", Right.VIEW).putAction("viewattachrev", Right.VIEW).putAction("get", Right.VIEW).putAction("downloadrev", Right.VIEW).putAction("plain", Right.VIEW).putAction("raw", Right.VIEW).putAction("attach", Right.VIEW).putAction("skin", Right.VIEW).putAction("download", Right.VIEW).putAction("pdf", Right.VIEW).putAction("undelete", Right.EDIT).putAction("reset", Right.DELETE).putAction("commentadd", Right.COMMENT).putAction("commentsave", Right.COMMENT).putAction("redirect", Right.VIEW).putAction("export", Right.VIEW).putAction("import", Right.ADMIN).putAction("jsx", Right.VIEW).putAction("ssx", Right.VIEW).putAction("tex", Right.VIEW).putAction("unknown", Right.VIEW).putAction("save", Right.EDIT).putAction("preview", Right.EDIT).putAction("lock", Right.EDIT).putAction("cancel", Right.EDIT).putAction("delattachment", Right.EDIT).putAction("inline", Right.EDIT).putAction("propadd", Right.EDIT).putAction("propupdate", Right.EDIT).putAction("propdelete", Right.EDIT).putAction("propdisable", Right.EDIT).putAction("propenable", Right.EDIT).putAction("objectadd", Right.EDIT).putAction("objectremove", Right.EDIT).putAction("objectsync", Right.EDIT).putAction("rollback", Right.EDIT).putAction("upload", Right.EDIT).putAction("create", Right.VIEW).putAction("deleteversions", Right.ADMIN).putAction("deletespace", Right.ADMIN).putAction("temp", Right.VIEW).putAction("webjars", Right.VIEW);
    }

    private static final class ActionMap
    extends HashMap<String, Right> {
        private static final long serialVersionUID = 1L;

        private ActionMap() {
        }

        public ActionMap putAction(String action, Right right) {
            this.put(action, right);
            return this;
        }
    }
}

