/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;

@Component
@Singleton
public class DefaultDocumentAuthorizationManager
implements DocumentAuthorizationManager {
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private DocumentRequiredRightsManager documentRequiredRightsManager;
    @Inject
    private Logger logger;

    public boolean hasAccess(Right right, EntityType level, DocumentReference contextAuthor, DocumentReference contextDocument) {
        EntityReference reference = contextDocument != null ? contextDocument.extractReference(level) : null;
        try {
            return this.hasRequiredRight(right, level, contextDocument) && this.authorizationManager.hasAccess(right, contextAuthor, reference);
        }
        catch (Exception e) {
            this.logger.error("Failed to load required rights for user [{}] on [{}].", new Object[]{contextAuthor, contextDocument, e});
            return false;
        }
    }

    public boolean hasRequiredRight(Right right, EntityType level, DocumentReference contextDocument) throws AuthorizationException {
        boolean hasAccess;
        DocumentRequiredRights documentRequiredRights = this.documentRequiredRightsManager.getRequiredRights(contextDocument).orElse(DocumentRequiredRights.EMPTY);
        if (documentRequiredRights.enforce()) {
            EntityType actualEntityType = DefaultDocumentAuthorizationManager.getFirstLevelWithRight(right, level, contextDocument);
            hasAccess = documentRequiredRights.rights().stream().filter(requiredRight -> Objects.equals(actualEntityType, requiredRight.scope()) || requiredRight.scope() == null || actualEntityType != null && actualEntityType.isAllowedAncestor(requiredRight.scope())).anyMatch(requiredRight -> requiredRight.right().equals(right) || requiredRight.right().getImpliedRights().contains(right));
        } else {
            hasAccess = true;
        }
        return hasAccess;
    }

    private static EntityType getFirstLevelWithRight(Right right, EntityType level, DocumentReference contextDocument) {
        Object actualEntityType = level;
        EntityReference entityReference = contextDocument.extractReference(level);
        while (!Right.getEnabledRights((EntityType)actualEntityType).contains(right)) {
            actualEntityType = (entityReference = entityReference.getParent()) != null ? entityReference.getType() : null;
            if (entityReference != null) continue;
        }
        return actualEntityType;
    }

    public void checkAccess(Right right, EntityType level, DocumentReference contextAuthor, DocumentReference contextDocument) throws AccessDeniedException {
        EntityReference reference = contextDocument != null ? contextDocument.extractReference(level) : null;
        try {
            if (!this.hasRequiredRight(right, level, contextDocument)) {
                this.logger.info("[{}] right has been denied to user [{}] on entity [{}] based on required rights of document [{}] on level [{}]: security checkpoint", new Object[]{right, contextAuthor, reference, contextDocument, level});
                throw new AccessDeniedException(right, contextAuthor, reference);
            }
            this.authorizationManager.checkAccess(right, contextAuthor, reference);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AccessDeniedException(right, contextAuthor, (EntityReference)contextDocument, (Throwable)e);
        }
    }
}

