/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRight;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRights;
import org.xwiki.security.authorization.requiredrights.DocumentRequiredRightsManager;

@Component(roles={DocumentRequiredRightsChecker.class})
@Singleton
public class DocumentRequiredRightsChecker {
    @Inject
    private Provider<AuthorizationManager> authorizationManagerProvider;
    @Inject
    private DocumentRequiredRightsManager documentRequiredRightsManager;

    public boolean hasRequiredRights(DocumentReference userReference, EntityReference entityReference) throws AuthorizationException {
        DocumentReference documentReference = this.getDocumentReference(entityReference);
        if (documentReference == null) {
            return true;
        }
        AuthorizationManager authorizationManager = (AuthorizationManager)this.authorizationManagerProvider.get();
        DocumentRequiredRights documentRequiredRights = this.documentRequiredRightsManager.getRequiredRights(documentReference).orElse(DocumentRequiredRights.EMPTY);
        if (documentRequiredRights.enforce()) {
            for (DocumentRequiredRight requiredRight : documentRequiredRights.rights()) {
                if (authorizationManager.hasAccess(requiredRight.right(), userReference, documentReference.extractReference(requiredRight.scope()))) continue;
                return false;
            }
        }
        return true;
    }

    private DocumentReference getDocumentReference(EntityReference entityReference) {
        if (entityReference != null) {
            if (entityReference instanceof DocumentReference) {
                DocumentReference documentReference = (DocumentReference)entityReference;
                return documentReference;
            }
            EntityReference documentEntityReference = entityReference.extractReference(EntityType.DOCUMENT);
            if (documentEntityReference != null) {
                return new DocumentReference(documentEntityReference);
            }
        }
        return null;
    }
}

