/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.cache.internal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.AuthorizationSettler;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntryReader;
import org.xwiki.security.authorization.SecurityRule;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.ConflictingInsertionException;
import org.xwiki.security.authorization.cache.ParentEntryEvictedException;
import org.xwiki.security.authorization.cache.SecurityCache;
import org.xwiki.security.authorization.cache.SecurityCacheLoader;
import org.xwiki.security.authorization.cache.internal.DefaultSecurityShadowEntry;
import org.xwiki.security.authorization.internal.AbstractSecurityRuleEntry;
import org.xwiki.security.internal.GroupSecurityEntry;
import org.xwiki.security.internal.UserBridge;

@Component
@Singleton
public class DefaultSecurityCacheLoader
implements SecurityCacheLoader {
    @Inject
    private Logger logger;
    @Inject
    private SecurityCache securityCache;
    @Inject
    private SecurityEntryReader securityEntryReader;
    @Inject
    private UserBridge userBridge;
    @Inject
    private Provider<AuthorizationSettler> authorizationSettlerProvider;

    private org.xwiki.security.authorization.cache.internal.SecurityCache getSecurityCache() {
        return (org.xwiki.security.authorization.cache.internal.SecurityCache)this.securityCache;
    }

    @Override
    public SecurityAccessEntry load(UserSecurityReference user, SecurityReference entity) throws AuthorizationException {
        if (entity == null) {
            return ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, this.loadGroupsOfUserOrGroup(user, user.getWikiReference(), null, new ArrayDeque<GroupSecurityReference>()), null);
        }
        long invalidationCounter = this.getSecurityCache().getInvalidationCounter();
        Deque<SecurityRuleEntry> ruleEntries = this.getRules(entity);
        return this.loadAccessEntries(user, entity, ruleEntries, invalidationCounter);
    }

    private SecurityAccessEntry loadAccessEntries(UserSecurityReference user, SecurityReference entity, Deque<SecurityRuleEntry> ruleEntries, long invalidationCounter) throws AuthorizationException {
        SecurityReference entityWiki;
        SecurityReference userWiki = user.getWikiReference();
        SecurityReference securityReference = entityWiki = user.isGlobal() ? entity.getWikiReference() : null;
        if (entityWiki != null && userWiki.equals((Object)entityWiki)) {
            entityWiki = null;
        }
        Collection<GroupSecurityReference> groups = user.getOriginalReference() == null ? this.loadPublicUser(user, entityWiki) : this.loadGroupsOfUserOrGroup(user, userWiki, entityWiki, new ArrayDeque<GroupSecurityReference>());
        SecurityAccessEntry accessEntry = ((AuthorizationSettler)this.authorizationSettlerProvider.get()).settle(user, groups, ruleEntries);
        try {
            this.getSecurityCache().add(accessEntry, entityWiki, invalidationCounter);
        }
        catch (ConflictingInsertionException | ParentEntryEvictedException e) {
            this.logFailedInsertion(e);
        }
        return accessEntry;
    }

    private Collection<GroupSecurityReference> loadGroupsOfUserOrGroup(UserSecurityReference user, SecurityReference userWiki, SecurityReference entityWiki, Deque<GroupSecurityReference> branchGroups) throws AuthorizationException {
        long invalidationCounter = this.getSecurityCache().getInvalidationCounter();
        Collection<GroupSecurityReference> groups = this.getSecurityCache().getGroupsFor(user, entityWiki);
        if (groups != null) {
            return groups;
        }
        HashSet<GroupSecurityReference> allImmediateGroups = new HashSet<GroupSecurityReference>();
        if (entityWiki != null) {
            allImmediateGroups.addAll(this.userBridge.getAllGroupsFor(user, entityWiki.getOriginalWikiReference()));
        }
        Collection<GroupSecurityReference> globalGroups = null;
        if (entityWiki != null) {
            globalGroups = this.getSecurityCache().getImmediateGroupsFor(user);
        }
        if (globalGroups == null) {
            globalGroups = this.userBridge.getAllGroupsFor(user, userWiki.getOriginalWikiReference());
        }
        allImmediateGroups.addAll(globalGroups);
        HashSet<GroupSecurityReference> groupsToIgnore = new HashSet<GroupSecurityReference>();
        groups = this.loadImmediateGroupsRecursively(allImmediateGroups, entityWiki, branchGroups, groupsToIgnore);
        globalGroups.removeAll(groupsToIgnore);
        allImmediateGroups.removeAll(groupsToIgnore);
        this.loadUserEntry(user, globalGroups, invalidationCounter);
        if (entityWiki != null) {
            try {
                this.getSecurityCache().add(new DefaultSecurityShadowEntry(user, entityWiki), allImmediateGroups, invalidationCounter);
            }
            catch (ConflictingInsertionException | ParentEntryEvictedException e) {
                this.logFailedInsertion(e);
            }
        }
        return groups;
    }

    private Collection<GroupSecurityReference> loadImmediateGroupsRecursively(Set<GroupSecurityReference> allImmediateGroups, SecurityReference entityWiki, Deque<GroupSecurityReference> branchGroups, Set<GroupSecurityReference> groupsToIgnore) throws AuthorizationException {
        HashSet<GroupSecurityReference> groups = new HashSet<GroupSecurityReference>();
        for (GroupSecurityReference group : allImmediateGroups) {
            if (branchGroups.contains((Object)group)) {
                groupsToIgnore.add(group);
                continue;
            }
            branchGroups.push(group);
            SecurityReference groupEntityWiki = group.isGlobal() ? entityWiki : null;
            Collection<GroupSecurityReference> nestedGroups = this.loadGroupsOfUserOrGroup(group, group.getWikiReference(), groupEntityWiki, branchGroups);
            if (branchGroups.stream().anyMatch(nestedGroups::contains)) {
                groupsToIgnore.add(group);
            } else {
                groups.add(group);
                groups.addAll(nestedGroups);
            }
            branchGroups.pop();
        }
        return groups;
    }

    private Collection<GroupSecurityReference> loadPublicUser(UserSecurityReference user, SecurityReference entityWiki) {
        if (entityWiki != null) {
            try {
                this.getSecurityCache().add(new DefaultSecurityShadowEntry(user, entityWiki), null, this.getSecurityCache().getInvalidationCounter());
            }
            catch (ConflictingInsertionException | ParentEntryEvictedException e) {
                this.logFailedInsertion(e);
            }
        }
        return Collections.emptySet();
    }

    private void loadUserEntry(UserSecurityReference user, Collection<GroupSecurityReference> groups, long invalidationCounter) throws AuthorizationException {
        Deque<SecurityReference> chain = user.getReversedSecurityReferenceChain();
        chain.removeLast();
        for (SecurityReference ref : chain) {
            SecurityRuleEntry entry = this.getSecurityCache().get(ref);
            if (entry != null) continue;
            entry = this.securityEntryReader.read(ref);
            this.addToCache(entry, invalidationCounter);
        }
        SecurityRuleEntry entry = this.securityEntryReader.read(user);
        try {
            this.getSecurityCache().add(entry, groups, invalidationCounter);
        }
        catch (ConflictingInsertionException | ParentEntryEvictedException e) {
            this.logFailedInsertion(e);
        }
    }

    private Deque<SecurityRuleEntry> getRules(SecurityReference entity) throws AuthorizationException {
        LinkedList<SecurityRuleEntry> rules = new LinkedList<SecurityRuleEntry>();
        ArrayList<SecurityRuleEntry> emptyRuleEntryTail = new ArrayList<SecurityRuleEntry>();
        long invalidationCounter = this.getSecurityCache().getInvalidationCounter();
        for (SecurityReference ref : entity.getReversedSecurityReferenceChain()) {
            SecurityRuleEntry entry = this.getSecurityCache().get(ref);
            if (entry == null) {
                if (Right.getEnabledRights(ref.getType()).isEmpty()) {
                    entry = new EmptySecurityRuleEntry(ref);
                    emptyRuleEntryTail.add(entry);
                } else {
                    entry = this.securityEntryReader.read(ref);
                    for (SecurityRuleEntry emptyRuleEntry : emptyRuleEntryTail) {
                        this.addToCache(emptyRuleEntry, invalidationCounter);
                    }
                    emptyRuleEntryTail.clear();
                    this.addToCache(entry, invalidationCounter);
                }
            }
            rules.push(entry);
        }
        return rules;
    }

    private void addToCache(SecurityRuleEntry entry, long invalidationCounter) {
        try {
            this.getSecurityCache().add(entry, invalidationCounter);
        }
        catch (ConflictingInsertionException | ParentEntryEvictedException e) {
            this.logFailedInsertion(e);
        }
    }

    private void logFailedInsertion(Exception e) {
        this.logger.debug("Insertion into the security cache failed. This may indicate that the security cache is too small or a bug.", (Throwable)e);
    }

    private final class EmptySecurityRuleEntry
    extends AbstractSecurityRuleEntry
    implements GroupSecurityEntry {
        private SecurityReference reference;

        private EmptySecurityRuleEntry(SecurityReference reference) {
            this.reference = reference;
        }

        @Override
        public SecurityReference getReference() {
            return this.reference;
        }

        @Override
        public void setGroupReference(GroupSecurityReference reference) {
            this.reference = reference;
        }

        @Override
        public Collection<SecurityRule> getRules() {
            return Collections.emptyList();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

