/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization.cache.internal;

import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.GroupSecurityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.UserSecurityReference;
import org.xwiki.security.authorization.SecurityAccessEntry;
import org.xwiki.security.authorization.SecurityEntry;
import org.xwiki.security.authorization.SecurityRuleEntry;
import org.xwiki.security.authorization.cache.ConflictingInsertionException;
import org.xwiki.security.authorization.cache.ParentEntryEvictedException;
import org.xwiki.security.authorization.cache.SecurityShadowEntry;
import org.xwiki.security.authorization.cache.internal.IllegalCacheStateException;
import org.xwiki.security.authorization.cache.internal.SecurityCache;
import org.xwiki.security.internal.GroupSecurityEntry;

@Component
@Singleton
public class DefaultSecurityCache
implements SecurityCache,
Initializable {
    private static final int DEFAULT_CAPACITY = 10000;
    private static final String KEY_CACHE_SEPARATOR = "@@";
    private static final String KEY_CACHE_SEPARATOR_ESCAPED = "@@@@";
    @Inject
    private Logger logger;
    private final AtomicLong invalidationCounter = new AtomicLong();
    private final AtomicBoolean invalidationInProgress = new AtomicBoolean();
    private final Lock writeLock = new ReentrantLock();
    private final ReadWriteLock invalidationReadWriteLock = new ReentrantReadWriteLock(true);
    private final Lock invalidationReadLock = this.invalidationReadWriteLock.readLock();
    private final Lock invalidationWriteLock = this.invalidationReadWriteLock.writeLock();
    @Inject
    private EntityReferenceSerializer<String> keySerializer;
    @Inject
    private CacheManager cacheManager;
    private Cache<SecurityCacheEntry> cache;
    private final Map<String, SecurityCacheEntry> internalEntries = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);

    private Cache<SecurityCacheEntry> newCache() throws InitializationException {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setConfigurationId("platform.security.authorization.cache");
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(10000);
        cacheConfig.put((Object)"eviction", (Object)lru);
        try {
            return this.cacheManager.createNewCache(cacheConfig);
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Unable to create the security cache with a capacity of [%d] entries", lru.getMaxEntries()), (Throwable)e);
        }
    }

    public void initialize() throws InitializationException {
        this.cache = this.newCache();
    }

    private String escapeEntryKey(String value) {
        return value.replace(KEY_CACHE_SEPARATOR, KEY_CACHE_SEPARATOR_ESCAPED);
    }

    private String getEntryKey(boolean shadow, EntityReference userReference, EntityReference reference) {
        StringBuilder builder = new StringBuilder();
        builder.append(shadow ? (char)'s' : 'n');
        if (userReference != null) {
            builder.append(this.escapeEntryKey((String)this.keySerializer.serialize(userReference, new Object[0])));
        }
        builder.append(KEY_CACHE_SEPARATOR);
        builder.append(reference.getType());
        builder.append(':');
        builder.append(this.escapeEntryKey((String)this.keySerializer.serialize(reference, new Object[0])));
        return builder.toString();
    }

    private String getEntryKey(SecurityReference reference) {
        return this.getEntryKey(null, reference);
    }

    private String getEntryKey(UserSecurityReference userReference, SecurityReference reference) {
        return this.getEntryKey(false, userReference, reference);
    }

    private String getShadowEntryKey(SecurityReference userReference, SecurityReference root) {
        return this.getEntryKey(true, userReference, root);
    }

    private String getEntryKey(SecurityEntry entry) {
        if (entry instanceof SecurityAccessEntry) {
            return this.getEntryKey((SecurityAccessEntry)entry);
        }
        if (entry instanceof SecurityRuleEntry) {
            return this.getEntryKey((SecurityRuleEntry)entry);
        }
        return this.getEntryKey((SecurityShadowEntry)entry);
    }

    private String getEntryKey(SecurityShadowEntry entry) {
        return this.getShadowEntryKey(entry.getReference(), entry.getWikiReference());
    }

    private String getEntryKey(SecurityRuleEntry entry) {
        return this.getEntryKey(entry.getReference());
    }

    private String getEntryKey(SecurityAccessEntry entry) {
        return this.getEntryKey(entry.getUserReference(), entry.getReference());
    }

    private SecurityCacheEntry getEntry(SecurityReference reference) {
        return this.getInternal(this.getEntryKey(reference), true);
    }

    private SecurityCacheEntry getEntry(UserSecurityReference userReference, SecurityReference reference) {
        return this.getInternal(this.getEntryKey(userReference, reference), false);
    }

    private SecurityCacheEntry getShadowEntry(SecurityReference userReference, SecurityReference wiki) {
        return this.getInternal(this.getShadowEntryKey(userReference, wiki), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityCacheEntry getInternal(String key, boolean checkInternalEntries) {
        SecurityCacheEntry result = (SecurityCacheEntry)this.cache.get(key);
        if (result == null && checkInternalEntries) {
            try {
                this.writeLock.lock();
                result = this.internalEntries.get(key);
                if (result != null) {
                    this.cache.set(key, (Object)result);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return result;
    }

    private boolean isAlreadyInserted(String key, SecurityEntry entry) throws ConflictingInsertionException {
        try {
            return this.isAlreadyInserted(key, entry, null);
        }
        catch (ParentEntryEvictedException e) {
            return true;
        }
    }

    private boolean isAlreadyInserted(String key, SecurityEntry entry, Collection<GroupSecurityReference> groups) throws ConflictingInsertionException, ParentEntryEvictedException {
        SecurityCacheEntry oldEntry = this.getInternal(key, true);
        if (oldEntry != null) {
            if (!oldEntry.getEntry().equals(entry)) {
                throw new ConflictingInsertionException(String.format("Another thread has inserted an entry [%s] which is different from entry [%s] with key [%s] and groups [%s]", oldEntry, entry, key, groups));
            }
            if (oldEntry.updateParentGroups(groups)) {
                VarHandle.fullFence();
                oldEntry.entry = entry;
            }
            return true;
        }
        return false;
    }

    private void addEntry(String key, SecurityCacheEntry entry) {
        this.cache.set(key, (Object)entry);
        if (!(entry.getEntry() instanceof SecurityAccessEntry)) {
            this.internalEntries.put(key, entry);
        }
        if (entry.disposed) {
            throw new IllegalCacheStateException(String.format("Entry [%s] has been disposed while being added to the cache.", entry));
        }
    }

    @Override
    public void add(SecurityRuleEntry entry, long invalidationCounter) throws ParentEntryEvictedException, ConflictingInsertionException {
        this.add(entry, null, invalidationCounter);
    }

    @Override
    public void add(SecurityRuleEntry entry, Collection<GroupSecurityReference> groups, long invalidationCounter) throws ConflictingInsertionException, ParentEntryEvictedException {
        this.add((SecurityEntry)entry, groups, invalidationCounter);
    }

    @Override
    public void add(SecurityShadowEntry entry, Collection<GroupSecurityReference> groups, long invalidationCounter) throws ConflictingInsertionException, ParentEntryEvictedException {
        this.add((SecurityEntry)entry, groups, invalidationCounter);
    }

    private void add(SecurityEntry entry, Collection<GroupSecurityReference> groups, long invalidationCounter) throws ConflictingInsertionException, ParentEntryEvictedException {
        String key = this.getEntryKey(entry);
        this.withWriteLockAndInvalidationCheck(invalidationCounter, key, () -> {
            if (this.isAlreadyInserted(key, entry, groups)) {
                return;
            }
            this.addEntry(key, this.newSecurityCacheEntry(entry, groups));
            this.logger.debug("Added rule/shadow entry [{}] into the cache.", (Object)key);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withWriteLockAndInvalidationCheck(long invalidationCounter, String key, SecurityCacheRunnable runnable) throws ConflictingInsertionException, ParentEntryEvictedException {
        if (this.getInvalidationCounter() != invalidationCounter || this.invalidationInProgress.get()) {
            this.logger.debug("Cancelling the addition of entry [{}] early because the invalidation counter doesn't match or an invalidation is in progress.", (Object)key);
            return;
        }
        this.writeLock.lock();
        try {
            if (this.getInvalidationCounter() != invalidationCounter) {
                this.logger.debug("Not adding the entry [{}] because the invalidation counter doesn't match", (Object)key);
                return;
            }
            runnable.run();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private SecurityCacheEntry newSecurityCacheEntry(SecurityEntry entry, Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException {
        if (entry instanceof SecurityRuleEntry) {
            return groups == null ? new SecurityCacheEntry((SecurityRuleEntry)entry) : new SecurityCacheEntry((SecurityRuleEntry)entry, groups);
        }
        return groups == null ? new SecurityCacheEntry((SecurityShadowEntry)entry) : new SecurityCacheEntry((SecurityShadowEntry)entry, groups);
    }

    @Override
    public void add(SecurityAccessEntry entry, long invalidationCounter) throws ParentEntryEvictedException, ConflictingInsertionException {
        this.internalAdd(entry, null, invalidationCounter);
    }

    @Override
    public void add(SecurityAccessEntry entry, SecurityReference wiki, long invalidationCounter) throws ParentEntryEvictedException, ConflictingInsertionException {
        this.internalAdd(entry, wiki, invalidationCounter);
    }

    private void internalAdd(SecurityAccessEntry entry, SecurityReference wiki, long invalidationCounter) throws ParentEntryEvictedException, ConflictingInsertionException {
        String key = this.getEntryKey(entry);
        this.withWriteLockAndInvalidationCheck(invalidationCounter, key, () -> {
            if (this.isAlreadyInserted(key, entry)) {
                return;
            }
            this.addEntry(key, new SecurityCacheEntry(entry, wiki));
            this.logger.debug("Added access entry [{}] into the cache.", (Object)key);
        });
    }

    @Override
    public long getInvalidationCounter() {
        return this.invalidationCounter.get();
    }

    SecurityEntry get(String entryKey) {
        SecurityCacheEntry entry = this.getInternal(entryKey, true);
        return entry != null ? entry.getEntry() : null;
    }

    @Override
    public SecurityAccessEntry get(UserSecurityReference user, SecurityReference entity) {
        SecurityCacheEntry entry = this.getEntry(user, entity);
        if (entry == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Miss read access entry for [{}].", (Object)this.getEntryKey(user, entity));
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Success read access entry for [{}].", (Object)this.getEntryKey(user, entity));
        }
        return (SecurityAccessEntry)entry.getEntry();
    }

    @Override
    public SecurityRuleEntry get(SecurityReference entity) {
        SecurityCacheEntry entry = this.getEntry(entity);
        if (entry == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Miss read rule entry for [{}].", (Object)this.getEntryKey(entity));
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Success read rule entry for [{}].", (Object)this.getEntryKey(entity));
        }
        return (SecurityRuleEntry)entry.getEntry();
    }

    @Override
    public void remove(UserSecurityReference user, SecurityReference entity) {
        this.withInvalidationAndWriteLocking(() -> {
            SecurityCacheEntry entry = this.getEntry(user, entity);
            if (entry != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove outdated access entry for [{}].", (Object)this.getEntryKey(user, entity));
                }
                entry.dispose();
            }
        });
    }

    @Override
    public void remove(SecurityReference entity) {
        this.withInvalidationAndWriteLocking(() -> {
            SecurityCacheEntry entry = this.getEntry(entity);
            if (entry != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Remove outdated rule entry for [{}].", (Object)this.getEntryKey(entity));
                }
                entry.dispose();
            }
        });
    }

    private void withInvalidationAndWriteLocking(Runnable r) {
        this.invalidationWriteLock.lock();
        try {
            this.writeLock.lock();
            this.invalidationInProgress.set(true);
            try {
                r.run();
            }
            finally {
                this.invalidationInProgress.set(false);
                this.invalidationCounter.incrementAndGet();
                this.writeLock.unlock();
            }
        }
        finally {
            this.invalidationWriteLock.unlock();
        }
    }

    @Override
    public Collection<GroupSecurityReference> getImmediateGroupsFor(UserSecurityReference user) {
        HashSet<GroupSecurityReference> groups = new HashSet<GroupSecurityReference>();
        SecurityCacheEntry userEntry = this.getEntry(user);
        if (userEntry == null || !userEntry.isUser()) {
            return null;
        }
        if (userEntry.parents != null) {
            for (SecurityCacheEntry parent : userEntry.parents) {
                SecurityReference parentRef = parent.getEntry().getReference();
                if (!(parentRef instanceof GroupSecurityReference)) continue;
                groups.add((GroupSecurityReference)parentRef);
            }
        }
        return groups;
    }

    @Override
    public Collection<GroupSecurityReference> getGroupsFor(UserSecurityReference user, SecurityReference entityWiki) {
        SecurityCacheEntry userEntry;
        HashSet<GroupSecurityReference> groups = new HashSet<GroupSecurityReference>();
        SecurityCacheEntry securityCacheEntry = userEntry = entityWiki != null ? this.getShadowEntry(user, entityWiki) : this.getEntry(user);
        if (userEntry == null || !userEntry.isUser()) {
            return null;
        }
        ArrayDeque<SecurityCacheEntry> entriesToExplore = new ArrayDeque<SecurityCacheEntry>();
        entriesToExplore.add(userEntry);
        while (!entriesToExplore.isEmpty()) {
            SecurityCacheEntry entry = (SecurityCacheEntry)entriesToExplore.pop();
            if (entry.parents == null) continue;
            for (SecurityCacheEntry parent : entry.parents) {
                if (!DefaultSecurityCache.isEntryGroupInWiki(parent, entityWiki) || !groups.add((GroupSecurityReference)parent.getEntry().getReference())) continue;
                entriesToExplore.add(parent);
            }
        }
        return groups;
    }

    private static boolean isEntryGroupInWiki(SecurityCacheEntry entry, SecurityReference entityWiki) {
        SecurityReference reference = entry.getEntry().getReference();
        return reference instanceof GroupSecurityReference && (entityWiki == null || entry.getEntry() instanceof SecurityShadowEntry || entityWiki.equals((Object)reference.getWikiReference()));
    }

    @Override
    public void suspendInvalidation() {
        this.invalidationReadLock.lock();
    }

    @Override
    public void resumeInvalidation() {
        this.invalidationReadLock.unlock();
    }

    private class SecurityCacheEntry {
        private SecurityEntry entry;
        private Collection<SecurityCacheEntry> parents;
        private Collection<SecurityCacheEntry> children;
        private boolean disposed;

        SecurityCacheEntry(SecurityRuleEntry entry) throws ParentEntryEvictedException {
            this.entry = entry;
            SecurityReference parentReference = entry.getReference().getParentSecurityReference();
            if (parentReference != null) {
                SecurityCacheEntry parent = DefaultSecurityCache.this.getEntry(parentReference);
                if (parent == null) {
                    throw new ParentEntryEvictedException(String.format("The parent with reference [%s] for entry [%s] is no longer available in the cache", new Object[]{parentReference, entry}));
                }
                this.parents = Arrays.asList(parent);
                parent.addChild(this);
                this.logNewEntry();
            } else {
                this.parents = null;
                this.logNewEntry();
            }
        }

        SecurityCacheEntry(SecurityShadowEntry entry) throws ParentEntryEvictedException {
            this.entry = entry;
            SecurityCacheEntry parent1 = DefaultSecurityCache.this.getEntry(entry.getReference());
            if (parent1 == null) {
                throw new ParentEntryEvictedException(String.format("The parent entry with reference [%s] for entry [%s] is no longer available in the cache", parent1, entry));
            }
            SecurityCacheEntry parent2 = DefaultSecurityCache.this.getEntry(entry.getWikiReference());
            if (parent2 == null) {
                throw new ParentEntryEvictedException(String.format("The wiki entry with reference [%s] for entry [%s] is no longer available in the cache", parent2, entry));
            }
            this.parents = Arrays.asList(parent1, parent2);
            parent1.addChild(this);
            parent2.addChild(this);
            this.logNewEntry();
        }

        SecurityCacheEntry(SecurityAccessEntry entry, SecurityReference wiki) throws ParentEntryEvictedException {
            SecurityCacheEntry parent2;
            this.entry = entry;
            boolean isSelf = entry.getReference().equals((Object)entry.getUserReference());
            SecurityCacheEntry parent1 = DefaultSecurityCache.this.getEntry(entry.getReference());
            if (parent1 == null) {
                throw new ParentEntryEvictedException(String.format("The first parent with reference [%s] for the entry [%s] with wiki [%s] is no longer available in the cache.", new Object[]{entry.getReference(), entry, wiki}));
            }
            SecurityCacheEntry securityCacheEntry = isSelf ? parent1 : (parent2 = wiki != null ? DefaultSecurityCache.this.getShadowEntry(entry.getUserReference(), wiki) : DefaultSecurityCache.this.getEntry(entry.getUserReference()));
            if (parent2 == null) {
                throw new ParentEntryEvictedException(String.format("The second parent with reference [%s] for the entry [%s] with wiki [%s] is no longer available in the cache.", new Object[]{entry.getUserReference(), entry, wiki}));
            }
            if (!parent2.isUser() && entry.getUserReference().getOriginalReference() != null) {
                throw new ParentEntryEvictedException(String.format("The second parent [%s] for the entry [%s] with wiki [%s] is not a user entry.", new Object[]{parent2, entry, wiki}));
            }
            this.parents = isSelf ? Arrays.asList(parent1) : Arrays.asList(parent1, parent2);
            parent1.addChild(this);
            if (!isSelf) {
                parent2.addChild(this);
            }
            this.logNewEntry();
        }

        SecurityCacheEntry(SecurityRuleEntry entry, Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException {
            this(entry, groups, entry.getReference().getParentSecurityReference());
        }

        SecurityCacheEntry(SecurityShadowEntry entry, Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException {
            this(entry, groups, entry.getReference());
        }

        private SecurityCacheEntry(SecurityEntry entry, Collection<GroupSecurityReference> groups, SecurityReference parentReference) throws ParentEntryEvictedException {
            this.entry = entry;
            int parentSize = groups.size() + (parentReference == null ? 0 : 1);
            if (parentSize > 0) {
                if (parentReference != null) {
                    this.parents = new ArrayList<SecurityCacheEntry>(parentSize);
                    SecurityCacheEntry parent = DefaultSecurityCache.this.getEntry(parentReference);
                    if (parent == null) {
                        throw new ParentEntryEvictedException(String.format("The parent with reference [%s] required by entry [%s] with groups [%s] is no longer available in the cache.", new Object[]{parentReference, entry, groups}));
                    }
                    this.parents.add(parent);
                    this.parents.addAll(this.getParentGroups(groups, parentReference));
                    parent.addChild(this);
                } else {
                    this.parents = this.getParentGroups(groups, null);
                }
            } else {
                this.parents = null;
            }
            this.logNewEntry();
        }

        private Collection<SecurityCacheEntry> getParentGroups(Collection<GroupSecurityReference> groups, SecurityReference parentReference) throws ParentEntryEvictedException {
            ArrayList<SecurityCacheEntry> result = new ArrayList<SecurityCacheEntry>(groups.size());
            for (GroupSecurityReference group : groups) {
                SecurityCacheEntry parent2;
                SecurityCacheEntry securityCacheEntry = parent2 = this.entry instanceof SecurityShadowEntry && group.isGlobal() ? DefaultSecurityCache.this.getShadowEntry(group, ((SecurityShadowEntry)this.entry).getWikiReference()) : DefaultSecurityCache.this.getEntry(group);
                if (parent2 == null) {
                    throw new ParentEntryEvictedException(String.format("The parent with reference [%s] is no longer available in the cache", new Object[]{parentReference}));
                }
                if (!parent2.isUser()) {
                    throw new ParentEntryEvictedException(String.format("The parent [%s] is not a group entry.", parent2.getEntry()));
                }
                if (!(parent2.getEntry().getReference() instanceof GroupSecurityReference) && parent2.getEntry() instanceof GroupSecurityEntry) {
                    ((GroupSecurityEntry)parent2.getEntry()).setGroupReference(group);
                }
                if (group.equals((Object)parentReference)) continue;
                result.add(parent2);
            }
            result.forEach(parent -> parent.addChild(this));
            return result;
        }

        boolean updateParentGroups(Collection<GroupSecurityReference> groups) throws ParentEntryEvictedException {
            if (this.isUser() || !(this.entry instanceof SecurityRuleEntry)) {
                return false;
            }
            if (groups != null && !groups.isEmpty()) {
                if (this.parents == null) {
                    this.parents = this.getParentGroups(groups, null);
                } else {
                    SecurityCacheEntry parent = this.parents.iterator().next();
                    ArrayList<SecurityCacheEntry> newParents = new ArrayList<SecurityCacheEntry>(groups.size() + 1);
                    newParents.add(parent);
                    newParents.addAll(this.getParentGroups(groups, parent.entry.getReference()));
                    this.parents = newParents;
                }
            }
            return true;
        }

        private void logNewEntry() {
            if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                if (CollectionUtils.isEmpty(this.parents)) {
                    DefaultSecurityCache.this.logger.debug("New orphan entry [{}].", (Object)this.getKey());
                    return;
                }
                StringBuilder sb = new StringBuilder("New entry [");
                sb.append(this.getKey()).append("] as child of ");
                boolean first = true;
                for (SecurityCacheEntry parent : this.parents) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append('[').append(parent.getKey()).append(']');
                }
                sb.append(".");
                DefaultSecurityCache.this.logger.debug(sb.toString());
            }
        }

        SecurityEntry getEntry() {
            return this.entry;
        }

        String getKey() {
            return DefaultSecurityCache.this.getEntryKey(this.entry);
        }

        public void dispose() {
            if (!this.disposed) {
                DefaultSecurityCache.this.cache.remove(this.getKey());
                DefaultSecurityCache.this.internalEntries.remove(this.getKey());
                this.disposed = true;
                this.disconnectFromParents();
                this.disposeChildren();
            }
        }

        protected void disconnectFromParents() {
            if (this.parents != null) {
                for (SecurityCacheEntry parent : this.parents) {
                    if (parent.disposed) continue;
                    parent.removeChild(this);
                }
            }
        }

        private void disposeChildren() {
            if (this.children != null) {
                for (SecurityCacheEntry child : this.children) {
                    if (child.disposed) continue;
                    if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                        DefaultSecurityCache.this.logger.debug("Cascaded removal of entry [{}] from cache.", (Object)child.getKey());
                    }
                    child.dispose();
                }
                this.children.clear();
            }
        }

        private void addChild(SecurityCacheEntry entry) {
            if (this.children == null) {
                this.children = Collections.newSetFromMap(new WeakHashMap());
            }
            this.children.add(entry);
        }

        private void removeChild(SecurityCacheEntry entry) {
            if (this.children != null) {
                this.children.remove(entry);
                if (DefaultSecurityCache.this.logger.isDebugEnabled()) {
                    DefaultSecurityCache.this.logger.debug("Remove child [{}] from [{}].", (Object)entry.getKey(), (Object)this.getKey());
                }
            }
        }

        public boolean isUser() {
            return this.entry.getReference() instanceof UserSecurityReference && !(this.entry instanceof SecurityAccessEntry);
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    @FunctionalInterface
    private static interface SecurityCacheRunnable {
        public void run() throws ConflictingInsertionException, ParentEntryEvictedException;
    }
}

