/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authorization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.xwiki.security.authorization.Right;

public class RightMap<V>
extends AbstractMap<Right, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Object NULL = new Object();
    private transient List<Object> rights = new ArrayList<Object>(Right.size());
    private transient Set<Right> keySet;
    private transient Collection<V> values;
    private transient Set<Map.Entry<Right, V>> entrySet;
    private transient int size;

    private Object maskNull(Object value) {
        return value == null ? NULL : value;
    }

    private V unmaskNull(Object value) {
        return (V)(value == NULL ? null : value);
    }

    @Override
    public void clear() {
        this.rights.clear();
        this.size = 0;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        RightMap clone = (RightMap)super.clone();
        clone.rights.addAll(this.rights);
        clone.size = this.size();
        return clone;
    }

    @Override
    public boolean containsKey(Object o) {
        return o instanceof Right && this.getValue(((Right)o).ordinal()) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.rights.contains(this.maskNull(o));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RightMap)) {
            return super.equals(o);
        }
        RightMap rmap = (RightMap)o;
        for (int i = 0; i < Right.size(); ++i) {
            V val = this.getValue(i);
            V rval = rmap.getValue(i);
            if (rval == val || rval != null && rval.equals(val)) continue;
            return false;
        }
        return true;
    }

    @Override
    public V get(Object o) {
        return o instanceof Right ? (V)this.unmaskNull(this.getValue(((Right)o).ordinal())) : null;
    }

    @Override
    public int hashCode() {
        return this.rights.isEmpty() ? 0 : this.rights.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private V getValue(int index) {
        return (V)(index < this.rights.size() ? this.rights.get(index) : null);
    }

    private V updateValue(int index, Object newValue) {
        Object oldValue;
        if (index < 0) {
            return null;
        }
        if (this.rights.size() <= index) {
            ((ArrayList)this.rights).ensureCapacity(Right.size() + 1);
            while (this.rights.size() <= Right.size()) {
                this.rights.add(null);
            }
        }
        if ((oldValue = this.rights.set(index, newValue)) == null) {
            if (newValue != null) {
                ++this.size;
            }
            return null;
        }
        if (newValue == null) {
            --this.size;
        }
        return this.unmaskNull(oldValue);
    }

    @Override
    public V put(Right right, V value) {
        return this.updateValue(right.ordinal(), this.maskNull(value));
    }

    @Override
    public void putAll(Map<? extends Right, ? extends V> map) {
        if (map instanceof RightMap) {
            RightMap rmap = (RightMap)map;
            for (int i = 0; i < Right.size(); ++i) {
                this.updateValue(i, rmap.getValue(i));
            }
        } else {
            super.putAll(map);
        }
    }

    @Override
    public V remove(Object o) {
        if (o instanceof Right) {
            return this.updateValue(((Right)o).ordinal(), null);
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (int i = 0; i < this.rights.size(); ++i) {
            if (this.getValue(i) == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(Right.get(i).getName()).append(" = ").append(this.unmaskNull(this.getValue(i)).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Set<Right> keySet() {
        if (this.keySet == null) {
            this.keySet = new RightSet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Right, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        for (Map.Entry<Right, V> e : this.entrySet()) {
            s.writeObject(e.getKey());
            s.writeObject(e.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.rights = new ArrayList<Object>(Right.size());
        for (int i = 0; i < s.readInt(); ++i) {
            Right key = (Right)s.readObject();
            Object value = s.readObject();
            this.put(key, value);
        }
    }

    private final class RightSet
    extends AbstractSet<Right> {
        private RightSet() {
        }

        @Override
        public Iterator<Right> iterator() {
            return new RightIterator();
        }

        @Override
        public int size() {
            return RightMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return RightMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = RightMap.this.size;
            RightMap.this.remove(o);
            return RightMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            RightMap.this.clear();
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return RightMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return RightMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            return RightMap.this.updateValue(RightMap.this.rights.indexOf(RightMap.this.maskNull(o)), null) != null;
        }

        @Override
        public void clear() {
            RightMap.this.clear();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<Right, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Right, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return entry.getKey() instanceof Right && RightMap.this.maskNull(entry.getValue()).equals(RightMap.this.getValue(((Right)entry.getKey()).ordinal()));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            if (this.contains(entry)) {
                RightMap.this.updateValue(((Right)entry.getKey()).ordinal(), null);
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return RightMap.this.size;
        }

        @Override
        public void clear() {
            RightMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.fillArray(new Object[RightMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            Object[] a = ts;
            if (a.length < RightMap.this.size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), RightMap.this.size);
            }
            if (a.length > RightMap.this.size) {
                a[RightMap.this.size] = null;
            }
            return this.fillArray(a);
        }

        private Object[] fillArray(Object[] a) {
            int j = 0;
            for (int i = 0; i < RightMap.this.rights.size(); ++i) {
                if (RightMap.this.getValue(i) == null) continue;
                a[j++] = new AbstractMap.SimpleEntry(Right.get(i), RightMap.this.unmaskNull(RightMap.this.getValue(i)));
            }
            return a;
        }
    }

    private final class EntryIterator
    extends AbstractRightMapIterator<Map.Entry<Right, V>>
    implements Map.Entry<Right, V> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<Right, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastIndex = this.index++;
            return this;
        }

        @Override
        public Right getKey() {
            this.checkLastIndex();
            return Right.get(this.lastIndex);
        }

        @Override
        public V getValue() {
            this.checkLastIndex();
            return RightMap.this.unmaskNull(RightMap.this.getValue(this.lastIndex));
        }

        @Override
        public V setValue(V value) {
            this.checkLastIndex();
            return RightMap.this.updateValue(this.lastIndex, value);
        }

        @Override
        public boolean equals(Object o) {
            if (this.lastIndex < 0) {
                return o == this;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object val = RightMap.this.unmaskNull(RightMap.this.getValue(this.lastIndex));
            Object rval = e.getValue();
            return e.getKey() == Right.get(this.lastIndex) && (val == rval || val != null && val.equals(rval));
        }

        @Override
        public int hashCode() {
            if (this.lastIndex < 0) {
                return super.hashCode();
            }
            Object value = RightMap.this.getValue(this.lastIndex);
            return Right.get(this.lastIndex).hashCode() ^ (value == NULL ? 0 : value.hashCode());
        }

        public String toString() {
            if (this.lastIndex < 0) {
                return super.toString();
            }
            return String.valueOf(Right.get(this.lastIndex)) + "=" + String.valueOf(RightMap.this.unmaskNull(RightMap.this.getValue(this.lastIndex)));
        }

        private void checkLastIndex() {
            if (this.lastIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
        }
    }

    private final class ValueIterator
    extends AbstractRightMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastIndex = this.index++;
            return RightMap.this.unmaskNull(RightMap.this.getValue(this.lastIndex));
        }
    }

    private final class RightIterator
    extends AbstractRightMapIterator<Right> {
        private RightIterator() {
        }

        @Override
        public Right next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastIndex = this.index++;
            return Right.get(this.lastIndex);
        }
    }

    private abstract class AbstractRightMapIterator<T>
    implements Iterator<T> {
        protected int index;
        protected int lastIndex = -1;

        private AbstractRightMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < RightMap.this.rights.size() && RightMap.this.getValue(this.index) == null) {
                ++this.index;
            }
            return this.index != RightMap.this.rights.size();
        }

        @Override
        public void remove() {
            if (this.lastIndex < 0) {
                throw new IllegalStateException();
            }
            RightMap.this.updateValue(this.lastIndex, null);
            this.lastIndex = -1;
        }
    }
}

