/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal.resource;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiContextInitializer;
import com.xpn.xwiki.web.Utils;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.security.authentication.AuthenticationResourceReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="authenticate")
@Singleton
public class AuthenticationResourceReferenceHandler
extends AbstractResourceReferenceHandler<ResourceType> {
    @Inject
    private XWikiContextInitializer xWikiContextInitializer;
    @Inject
    private Execution execution;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public List<ResourceType> getSupportedResourceReferences() {
        return Collections.singletonList(AuthenticationResourceReference.TYPE);
    }

    public void handle(ResourceReference reference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        AuthenticationResourceReference authenticationResourceReference = (AuthenticationResourceReference)reference;
        WikiReference wikiReference = authenticationResourceReference.getWikiReference();
        try {
            if (!this.wikiDescriptorManager.exists(wikiReference.getName())) {
                throw new ResourceReferenceHandlerException(String.format("The wiki [%s] does not exist.", wikiReference.getName()));
            }
        }
        catch (WikiManagerException e) {
            throw new ResourceReferenceHandlerException(String.format("Error when checking if wiki [%s] exists.", wikiReference.getName()), (Throwable)e);
        }
        switch (authenticationResourceReference.getAction()) {
            case RETRIEVE_USERNAME: {
                this.handleAction("forgotusername", authenticationResourceReference.getWikiReference());
                break;
            }
            case RESET_PASSWORD: {
                this.handleAction("resetpassword", authenticationResourceReference.getWikiReference());
                break;
            }
        }
        chain.handleNext(reference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAction(String templateName, WikiReference wikiReference) throws ResourceReferenceHandlerException {
        ExecutionContext executionContext = this.execution.getContext();
        if (executionContext == null) {
            executionContext = new ExecutionContext();
        }
        WikiReference currentWiki = null;
        XWikiContext context = null;
        try {
            context = this.xWikiContextInitializer.initialize(executionContext);
            currentWiki = context.getWikiReference();
            context.setWikiReference(wikiReference);
            Utils.parseTemplate((String)templateName, (boolean)true, (XWikiContext)context);
            if (currentWiki == null) return;
        }
        catch (Exception e) {
            try {
                throw new ResourceReferenceHandlerException(String.format("Error while rendering template [%s]: [%s].", templateName, ExceptionUtils.getRootCauseMessage((Throwable)e)), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (currentWiki == null) throw throwable;
                context.setWikiReference(currentWiki);
                throw throwable;
            }
        }
        context.setWikiReference(currentWiki);
        return;
    }
}

