/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PasswordClass;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceSerializer;
import org.xwiki.resource.SerializeResourceReferenceException;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.security.authentication.AuthenticationAction;
import org.xwiki.security.authentication.AuthenticationResourceReference;
import org.xwiki.security.authentication.RegistrationConfiguration;
import org.xwiki.security.authentication.ResetPasswordException;
import org.xwiki.security.authentication.ResetPasswordManager;
import org.xwiki.security.authentication.ResetPasswordRequestResponse;
import org.xwiki.security.authentication.internal.AuthenticationMailSender;
import org.xwiki.security.authentication.internal.DefaultResetPasswordRequestResponse;
import org.xwiki.security.authentication.internal.ResetPasswordRequestClassDocumentInitializer;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.URLNormalizer;
import org.xwiki.user.UserException;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserProperties;
import org.xwiki.user.UserPropertiesResolver;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;
import org.xwiki.user.internal.document.DocumentUserReference;

@Component
@Singleton
public class DefaultResetPasswordManager
implements ResetPasswordManager {
    protected static final String XWIKI_SPACE = "XWiki";
    protected static final LocalDocumentReference LDAP_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "LDAPProfileClass");
    protected static final LocalDocumentReference USER_CLASS_REFERENCE = new LocalDocumentReference("XWiki", "XWikiUsers");
    protected static final String TOKEN_LIFETIME = "security.authentication.resetPasswordTokenLifetime";
    @Inject
    private UserManager userManager;
    @Inject
    private UserPropertiesResolver userPropertiesResolver;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ResourceReferenceSerializer<ResourceReference, ExtendedURL> resourceReferenceSerializer;
    @Inject
    @Named(value="contextpath")
    private URLNormalizer<ExtendedURL> urlNormalizer;
    @Inject
    private UserReferenceSerializer<String> referenceSerializer;
    @Inject
    private Provider<AuthenticationMailSender> resetPasswordMailSenderProvider;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configurationSource;
    @Inject
    private RegistrationConfiguration registrationConfiguration;
    @Inject
    private Logger logger;

    private UserInformation getUserInformation(UserReference userReference) throws ResetPasswordException {
        if (!(userReference instanceof DocumentUserReference)) {
            throw new ResetPasswordException("Only user having a page on the wiki can reset their password.");
        }
        UserInformation result = new UserInformation();
        try {
            result.userExists = this.userManager.exists(userReference);
            result.userProperties = this.userPropertiesResolver.resolve(userReference, new Object[0]);
            result.userEmail = result.userProperties.getEmail();
            return result;
        }
        catch (UserException e) {
            throw new ResetPasswordException(String.format("Failed to check if user [%s] exists.", userReference), (Throwable)e);
        }
    }

    public ResetPasswordRequestResponse requestResetPassword(UserReference userReference) throws ResetPasswordException {
        UserInformation userInformation = this.getUserInformation(userReference);
        if (userInformation.canUserResetPassword()) {
            DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
            DocumentReference reference = documentUserReference.getReference();
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            try {
                XWikiDocument userDocument = context.getWiki().getDocument(reference, context);
                if (userDocument.getXObject((EntityReference)LDAP_CLASS_REFERENCE) != null) {
                    String exceptionMessage = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.error.ldapUser", new Object[]{userReference.toString()});
                    throw new ResetPasswordException(exceptionMessage);
                }
                userDocument = userDocument.clone();
                BaseObject xObject = userDocument.getXObject((EntityReference)ResetPasswordRequestClassDocumentInitializer.REFERENCE, true, context);
                String verificationCode = context.getWiki().generateRandomString(30);
                xObject.set("verification", (Object)verificationCode, context);
                xObject.setDateValue("requestDate", new Date());
                String saveComment = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.versionComment", new Object[0]);
                context.getWiki().saveDocument(userDocument, saveComment, true, context);
                return new DefaultResetPasswordRequestResponse(userReference, verificationCode);
            }
            catch (XWikiException e) {
                throw new ResetPasswordException("Error when reading user document to perform reset password request.", (Throwable)e);
            }
        }
        if (userInformation.userExists && userInformation.userEmail == null) {
            this.logger.info("User [{}] asked to reset their password, but did not have any email configured.", (Object)userReference);
        }
        return new DefaultResetPasswordRequestResponse(userReference);
    }

    public void sendResetPasswordEmailRequest(ResetPasswordRequestResponse requestResponse) throws ResetPasswordException {
        UserInformation userInformation = this.getUserInformation(requestResponse.getUserReference());
        if (userInformation.canUserResetPassword()) {
            AuthenticationResourceReference resourceReference = new AuthenticationResourceReference(((XWikiContext)this.contextProvider.get()).getWikiReference(), AuthenticationAction.RESET_PASSWORD);
            UserReference userReference = requestResponse.getUserReference();
            String serializedUserReference = (String)this.referenceSerializer.serialize(userReference);
            Object formattedName = "";
            if (!StringUtils.isBlank((CharSequence)userInformation.userProperties.getFirstName())) {
                formattedName = (String)formattedName + userInformation.userProperties.getFirstName();
            }
            if (!StringUtils.isBlank((CharSequence)userInformation.userProperties.getLastName())) {
                if (!StringUtils.isBlank((CharSequence)formattedName)) {
                    formattedName = (String)formattedName + " ";
                }
                formattedName = (String)formattedName + userInformation.userProperties.getLastName();
            }
            if (StringUtils.isBlank((CharSequence)formattedName)) {
                formattedName = serializedUserReference;
            }
            resourceReference.addParameter("u", (Object)serializedUserReference);
            resourceReference.addParameter("v", (Object)requestResponse.getVerificationCode());
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            ExtendedURL extendedURL = null;
            try {
                extendedURL = (ExtendedURL)this.resourceReferenceSerializer.serialize((ResourceReference)resourceReference);
                extendedURL = (ExtendedURL)this.urlNormalizer.normalize(extendedURL);
                URL serverURL = context.getURLFactory().getServerURL(context);
                URL externalVerificationURL = new URL(serverURL, extendedURL.serialize());
                ((AuthenticationMailSender)this.resetPasswordMailSenderProvider.get()).sendResetPasswordEmail((String)formattedName, userInformation.userEmail, externalVerificationURL);
            }
            catch (MalformedURLException | SerializeResourceReferenceException | UnsupportedResourceReferenceException e) {
                throw new ResetPasswordException("Error when processing information for creating the email.", e);
            }
        }
    }

    private int getTokenLifeTime() {
        return (Integer)this.configurationSource.getProperty(TOKEN_LIFETIME, (Object)60);
    }

    private boolean isTokenExpired(BaseObject requestXObject) {
        int tokenLifeTime = this.getTokenLifeTime();
        boolean result = false;
        if (tokenLifeTime > 0) {
            Date dateValue = requestXObject.getDateValue("requestDate");
            if (dateValue == null) {
                return true;
            }
            Instant saveInstant = dateValue.toInstant();
            Instant now = Instant.now();
            return saveInstant.plus((long)tokenLifeTime, ChronoUnit.MINUTES).isBefore(now);
        }
        return result;
    }

    public ResetPasswordRequestResponse checkVerificationCode(UserReference userReference, String verificationCode) throws ResetPasswordException {
        DefaultResetPasswordRequestResponse result = new DefaultResetPasswordRequestResponse(userReference);
        UserInformation userInformation = this.getUserInformation(userReference);
        if (userInformation.canUserResetPassword()) {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
            DocumentReference reference = documentUserReference.getReference();
            String exceptionMessage = this.localizationManager.getTranslationPlain("security.authentication.resetPassword.error.badParameters", new Object[0]);
            try {
                XWikiDocument userDocument = context.getWiki().getDocument(reference, context);
                BaseObject xObject = userDocument.getXObject((EntityReference)ResetPasswordRequestClassDocumentInitializer.REFERENCE);
                if (xObject == null) {
                    throw new ResetPasswordException(exceptionMessage);
                }
                String storedVerificationCode = xObject.getStringValue("verification");
                BaseClass xClass = xObject.getXClass(context);
                PropertyInterface verification = xClass.get("verification");
                if (!(verification instanceof PasswordClass)) {
                    throw new ResetPasswordException("Bad definition of ResetPassword XClass.");
                }
                PasswordClass passwordClass = (PasswordClass)verification;
                String equivalentPassword = passwordClass.getEquivalentPassword(storedVerificationCode, verificationCode);
                if (this.isTokenExpired(xObject)) {
                    this.resetVerificationCode(userDocument, "security.authentication.resetPassword.tokenExpired");
                    throw new ResetPasswordException(exceptionMessage);
                }
                if (!storedVerificationCode.equals(equivalentPassword)) {
                    if (this.getTokenLifeTime() <= 0) {
                        this.resetVerificationCode(userDocument, "security.authentication.resetPassword.badToken");
                    }
                    throw new ResetPasswordException(exceptionMessage);
                }
                result = new DefaultResetPasswordRequestResponse(userReference, verificationCode);
            }
            catch (XWikiException e) {
                throw new ResetPasswordException("Cannot open user document to check verification code.", (Throwable)e);
            }
        }
        return result;
    }

    private void resetVerificationCode(XWikiDocument userDocument, String saveCommentTranslationKey) throws XWikiException {
        XWikiDocument document = userDocument;
        if (document.isCached()) {
            document = userDocument.clone();
        }
        document.removeXObjects((EntityReference)ResetPasswordRequestClassDocumentInitializer.REFERENCE);
        String saveComment = this.localizationManager.getTranslationPlain(saveCommentTranslationKey, new Object[0]);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        context.getWiki().saveDocument(document, saveComment, true, context);
    }

    public void resetPassword(UserReference userReference, String newPassword) throws ResetPasswordException {
        UserInformation userInformation = this.getUserInformation(userReference);
        if (userInformation.canUserResetPassword()) {
            if (!this.isPasswordCompliantWithRegistrationRules(newPassword)) {
                throw new ResetPasswordException("The provided password is not compliant with the password security rules.");
            }
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            DocumentUserReference documentUserReference = (DocumentUserReference)userReference;
            DocumentReference reference = documentUserReference.getReference();
            try {
                XWikiDocument userDocument = context.getWiki().getDocument(reference, context);
                userDocument = userDocument.clone();
                userDocument.removeXObjects((EntityReference)ResetPasswordRequestClassDocumentInitializer.REFERENCE);
                BaseObject userXObject = userDocument.getXObject((EntityReference)USER_CLASS_REFERENCE);
                userXObject.set("password", (Object)newPassword, context);
                String saveComment = this.localizationManager.getTranslationPlain("xe.admin.passwordReset.step2.versionComment.passwordReset", new Object[0]);
                context.getWiki().saveDocument(userDocument, saveComment, true, context);
            }
            catch (XWikiException e) {
                throw new ResetPasswordException("Cannot open user document to perform reset password.", (Throwable)e);
            }
        }
    }

    public boolean isPasswordCompliantWithRegistrationRules(String newPassword) {
        boolean result;
        int passwordMinimumLength = this.registrationConfiguration.getPasswordMinimumLength();
        boolean bl = result = newPassword.length() >= passwordMinimumLength;
        if (result) {
            for (RegistrationConfiguration.PasswordRules passwordRule : this.registrationConfiguration.getPasswordRules()) {
                if (passwordRule.getPattern().matcher(newPassword).matches()) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static final class UserInformation {
        private boolean userExists;
        private InternetAddress userEmail;
        private UserProperties userProperties;

        private UserInformation() {
        }

        boolean canUserResetPassword() {
            return this.userExists && this.userEmail != null;
        }
    }
}

