/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.security.authentication.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.security.authentication.AuthenticationConfiguration;

@Component
@Singleton
public class DefaultAuthenticationConfiguration
implements AuthenticationConfiguration {
    @Inject
    @Named(value="authentication")
    private ConfigurationSource configuration;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikiCfgConfiguration;
    @Inject
    @Named(value="permanent")
    private ConfigurationSource permanentConfiguration;
    @Inject
    private Logger logger;
    private String validationKey;
    private String encryptionKey;

    public int getMaxAuthorizedAttempts() {
        return (Integer)this.configuration.getProperty("maxAuthorizedAttempts", (Object)3);
    }

    public int getTimeWindow() {
        return (Integer)this.configuration.getProperty("timeWindowAttempts", (Object)300);
    }

    public String[] getFailureStrategies() {
        String strategies = (String)this.configuration.getProperty("failureStrategy", (Object)"");
        if (!StringUtils.isEmpty((CharSequence)strategies)) {
            return strategies.split(",");
        }
        return new String[0];
    }

    public boolean isAuthenticationSecurityEnabled() {
        return (Boolean)this.configuration.getProperty("isAuthenticationSecurityEnabled", (Object)true);
    }

    public List<String> getCookieDomains() {
        return (List)this.xwikiCfgConfiguration.getProperty("xwiki.authentication.cookiedomains", List.class, List.of());
    }

    public String getValidationKey() {
        if (this.validationKey == null) {
            this.validationKey = this.getGeneratedKey("xwiki.authentication.validationKey");
        }
        return this.validationKey;
    }

    public String getEncryptionKey() {
        if (this.encryptionKey == null) {
            this.encryptionKey = this.getGeneratedKey("xwiki.authentication.encryptionKey");
        }
        return this.encryptionKey;
    }

    private synchronized String getGeneratedKey(String name) {
        String generatedKey = (String)this.xwikiCfgConfiguration.getProperty(name, String.class);
        if (generatedKey == null) {
            generatedKey = (String)this.permanentConfiguration.getProperty(name, String.class);
        }
        if (generatedKey == null) {
            generatedKey = RandomStringUtils.secure().next(32);
            try {
                this.permanentConfiguration.setProperty(name, (Object)generatedKey);
            }
            catch (ConfigurationSaveException e) {
                this.logger.error("Failed to store the key, it will be generated at each restart", (Throwable)e);
            }
        }
        return generatedKey;
    }
}

