/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.script;

import com.xpn.xwiki.XWikiContext;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.solr.common.SolrDocument;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.script.service.ScriptService;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="solr")
@Singleton
public class SolrIndexScriptService
implements ScriptService {
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    @Inject
    private Logger logger;
    @Inject
    private SolrIndexer solrIndexer;
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<SolrDocument> solrDocumentReferenceResolver;
    @Inject
    private EntityReferenceResolver<SolrDocument> solrEntityReferenceResolver;

    public void index(EntityReference reference) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(reference);
            this.solrIndexer.index(reference, true);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void index(List<EntityReference> references) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(references);
            for (EntityReference reference : references) {
                this.solrIndexer.index(reference, true);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void delete(EntityReference reference) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(reference);
            this.solrIndexer.delete(reference, true);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void delete(List<EntityReference> references) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(references);
            for (EntityReference reference : references) {
                this.solrIndexer.delete(reference, true);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public int getQueueSize() {
        return this.solrIndexer.getQueueSize();
    }

    public DocumentReference resolveDocument(SolrDocument document, Object ... parameters) {
        return this.solrDocumentReferenceResolver.resolve((Object)document, parameters);
    }

    public EntityReference resolve(SolrDocument document, Object ... parameters) {
        EntityType type;
        try {
            type = EntityType.valueOf((String)((String)document.get((Object)"type")));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
        return this.resolve(document, type, parameters);
    }

    public EntityReference resolve(SolrDocument document, EntityType type, Object ... parameters) {
        return this.solrEntityReferenceResolver.resolve((Object)document, type, parameters);
    }

    private void error(String errorMessage, Exception e) {
        String errorMessageToLog = errorMessage;
        if (errorMessageToLog == null) {
            errorMessageToLog = e.getMessage();
        }
        this.logger.error(errorMessageToLog, (Throwable)e);
        ((XWikiContext)this.xcontextProvider.get()).put((Object)CONTEXT_LASTEXCEPTION, (Object)e);
    }

    private void error(Exception e) {
        this.error(null, e);
    }

    private void clearException() {
        ((XWikiContext)this.xcontextProvider.get()).remove((Object)CONTEXT_LASTEXCEPTION);
    }

    private void checkAccessToWikiIndex(EntityReference reference) throws AccessDeniedException {
        EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        this.authorization.checkAccess(Right.ADMIN, xcontext.getUserReference(), wikiReference);
        this.contextualAuthorizationManager.checkAccess(Right.PROGRAM);
    }

    private void checkAccessToWikiIndex(List<EntityReference> references) throws AccessDeniedException {
        HashSet<EntityReference> representatives = new HashSet<EntityReference>();
        for (EntityReference reference : references) {
            EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
            if (representatives.contains(wikiReference)) continue;
            this.checkAccessToWikiIndex(wikiReference);
            representatives.add(wikiReference);
        }
    }
}

