/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultSolrReferenceResolver
implements SolrReferenceResolver {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    private SolrReferenceResolver getResover(EntityReference reference) throws SolrIndexerException {
        SolrReferenceResolver resolver;
        EntityType type = reference.getType();
        try {
            resolver = (SolrReferenceResolver)this.componentManager.getInstance(SolrReferenceResolver.class, type.getLowerCase());
        }
        catch (ComponentLookupException e) {
            throw new SolrIndexerException("Failed to get SolrDocumentReferenceResolver corresponding to entity type [" + String.valueOf(type) + "]", (Exception)((Object)e));
        }
        return resolver;
    }

    @Override
    public Iterable<EntityReference> getReferences(EntityReference reference) throws SolrIndexerException {
        ArrayList wikis;
        if (reference != null) {
            return this.getResover(reference).getReferences(reference);
        }
        try {
            wikis = new ArrayList(this.wikiDescriptorManager.getAllIds());
        }
        catch (WikiManagerException e) {
            throw new SolrIndexerException("Failed to get the list of available wikis.", (Exception)((Object)e));
        }
        return new Iterable<EntityReference>(){

            @Override
            public Iterator<EntityReference> iterator() {
                return new FarmIterator(wikis);
            }
        };
    }

    @Override
    public String getId(EntityReference reference) throws SolrIndexerException, IllegalArgumentException {
        if (reference != null) {
            return this.getResover(reference).getId(reference);
        }
        return null;
    }

    @Override
    public String getQuery(EntityReference reference) throws SolrIndexerException {
        if (reference != null) {
            return this.getResover(reference).getQuery(reference);
        }
        return "*:*";
    }

    class FarmIterator
    implements Iterator<EntityReference> {
        private Iterator<EntityReference> currentIterator;
        private final Iterator<String> currentWiki;

        FarmIterator(List<String> wikis) {
            this.currentWiki = wikis.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            this.update();
            return this.currentIterator != null;
        }

        @Override
        public EntityReference next() {
            this.update();
            return this.currentIterator != null ? this.currentIterator.next() : null;
        }

        private void update() {
            if (this.currentIterator == null || !this.currentIterator.hasNext()) {
                if (this.currentWiki.hasNext()) {
                    String wiki = this.currentWiki.next();
                    try {
                        this.currentIterator = DefaultSolrReferenceResolver.this.getReferences((EntityReference)new WikiReference(wiki)).iterator();
                    }
                    catch (SolrIndexerException e) {
                        DefaultSolrReferenceResolver.this.logger.error("Failed to get references for wiki [" + wiki + "]", (Throwable)e);
                    }
                    if (!this.currentIterator.hasNext()) {
                        this.update();
                    }
                } else {
                    this.currentIterator = null;
                }
            }
        }
    }
}

