/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.reference;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.slf4j.Logger;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

public abstract class AbstractSolrReferenceResolver
implements SolrReferenceResolver {
    protected static final String QUERY_AND = " AND ";
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    @Inject
    protected Logger logger;

    protected XWikiDocument getDocument(DocumentReference documentReference) throws Exception {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = context.getWiki().getDocument(documentReference, context);
        return document;
    }

    @Override
    public String getId(EntityReference reference) throws SolrIndexerException, IllegalArgumentException {
        String result = (String)this.serializer.serialize(reference, new Object[0]);
        return result;
    }

    @Override
    public String getQuery(EntityReference reference) throws IllegalArgumentException, SolrIndexerException {
        return "id:" + ClientUtils.escapeQueryChars((String)this.getId(reference));
    }
}

